/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ContractEvent;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class DiagnosticEvent
implements XdrElement {
    private Boolean inSuccessfulContractCall;
    private ContractEvent event;

    public Boolean getInSuccessfulContractCall() {
        return this.inSuccessfulContractCall;
    }

    public void setInSuccessfulContractCall(Boolean value) {
        this.inSuccessfulContractCall = value;
    }

    public ContractEvent getEvent() {
        return this.event;
    }

    public void setEvent(ContractEvent value) {
        this.event = value;
    }

    public static void encode(XdrDataOutputStream stream, DiagnosticEvent encodedDiagnosticEvent) throws IOException {
        stream.writeInt(encodedDiagnosticEvent.inSuccessfulContractCall != false ? 1 : 0);
        ContractEvent.encode(stream, encodedDiagnosticEvent.event);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        DiagnosticEvent.encode(stream, this);
    }

    public static DiagnosticEvent decode(XdrDataInputStream stream) throws IOException {
        DiagnosticEvent decodedDiagnosticEvent = new DiagnosticEvent();
        decodedDiagnosticEvent.inSuccessfulContractCall = stream.readInt() == 1;
        decodedDiagnosticEvent.event = ContractEvent.decode(stream);
        return decodedDiagnosticEvent;
    }

    public int hashCode() {
        return Objects.hash(this.inSuccessfulContractCall, this.event);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DiagnosticEvent)) {
            return false;
        }
        DiagnosticEvent other = (DiagnosticEvent)object;
        return Objects.equals(this.inSuccessfulContractCall, other.inSuccessfulContractCall) && Objects.equals(this.event, other.event);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static DiagnosticEvent fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return DiagnosticEvent.fromXdrByteArray(bytes);
    }

    public static DiagnosticEvent fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return DiagnosticEvent.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Boolean inSuccessfulContractCall;
        private ContractEvent event;

        public Builder inSuccessfulContractCall(Boolean inSuccessfulContractCall) {
            this.inSuccessfulContractCall = inSuccessfulContractCall;
            return this;
        }

        public Builder event(ContractEvent event) {
            this.event = event;
            return this;
        }

        public DiagnosticEvent build() {
            DiagnosticEvent val = new DiagnosticEvent();
            val.setInSuccessfulContractCall(this.inSuccessfulContractCall);
            val.setEvent(this.event);
            return val;
        }
    }
}

