/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.MessageType;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class DontHave
implements XdrElement {
    private MessageType type;
    private Uint256 reqHash;

    public MessageType getType() {
        return this.type;
    }

    public void setType(MessageType value) {
        this.type = value;
    }

    public Uint256 getReqHash() {
        return this.reqHash;
    }

    public void setReqHash(Uint256 value) {
        this.reqHash = value;
    }

    public static void encode(XdrDataOutputStream stream, DontHave encodedDontHave) throws IOException {
        MessageType.encode(stream, encodedDontHave.type);
        Uint256.encode(stream, encodedDontHave.reqHash);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        DontHave.encode(stream, this);
    }

    public static DontHave decode(XdrDataInputStream stream) throws IOException {
        DontHave decodedDontHave = new DontHave();
        decodedDontHave.type = MessageType.decode(stream);
        decodedDontHave.reqHash = Uint256.decode(stream);
        return decodedDontHave;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.reqHash);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DontHave)) {
            return false;
        }
        DontHave other = (DontHave)object;
        return Objects.equals(this.type, other.type) && Objects.equals(this.reqHash, other.reqHash);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static DontHave fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return DontHave.fromXdrByteArray(bytes);
    }

    public static DontHave fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return DontHave.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private MessageType type;
        private Uint256 reqHash;

        public Builder type(MessageType type) {
            this.type = type;
            return this;
        }

        public Builder reqHash(Uint256 reqHash) {
            this.reqHash = reqHash;
            return this;
        }

        public DontHave build() {
            DontHave val = new DontHave();
            val.setType(this.type);
            val.setReqHash(this.reqHash);
            return val;
        }
    }
}

