/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.TransactionSetV1;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class GeneralizedTransactionSet
implements XdrElement {
    Integer v;
    private TransactionSetV1 v1TxSet;

    public Integer getDiscriminant() {
        return this.v;
    }

    public void setDiscriminant(Integer value) {
        this.v = value;
    }

    public TransactionSetV1 getV1TxSet() {
        return this.v1TxSet;
    }

    public void setV1TxSet(TransactionSetV1 value) {
        this.v1TxSet = value;
    }

    public static void encode(XdrDataOutputStream stream, GeneralizedTransactionSet encodedGeneralizedTransactionSet) throws IOException {
        stream.writeInt(encodedGeneralizedTransactionSet.getDiscriminant());
        switch (encodedGeneralizedTransactionSet.getDiscriminant()) {
            case 1: {
                TransactionSetV1.encode(stream, encodedGeneralizedTransactionSet.v1TxSet);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        GeneralizedTransactionSet.encode(stream, this);
    }

    public static GeneralizedTransactionSet decode(XdrDataInputStream stream) throws IOException {
        GeneralizedTransactionSet decodedGeneralizedTransactionSet = new GeneralizedTransactionSet();
        Integer discriminant = stream.readInt();
        decodedGeneralizedTransactionSet.setDiscriminant(discriminant);
        switch (decodedGeneralizedTransactionSet.getDiscriminant()) {
            case 1: {
                decodedGeneralizedTransactionSet.v1TxSet = TransactionSetV1.decode(stream);
            }
        }
        return decodedGeneralizedTransactionSet;
    }

    public int hashCode() {
        return Objects.hash(this.v1TxSet, this.v);
    }

    public boolean equals(Object object) {
        if (!(object instanceof GeneralizedTransactionSet)) {
            return false;
        }
        GeneralizedTransactionSet other = (GeneralizedTransactionSet)object;
        return Objects.equals(this.v1TxSet, other.v1TxSet) && Objects.equals(this.v, other.v);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static GeneralizedTransactionSet fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return GeneralizedTransactionSet.fromXdrByteArray(bytes);
    }

    public static GeneralizedTransactionSet fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return GeneralizedTransactionSet.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Integer discriminant;
        private TransactionSetV1 v1TxSet;

        public Builder discriminant(Integer discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder v1TxSet(TransactionSetV1 v1TxSet) {
            this.v1TxSet = v1TxSet;
            return this;
        }

        public GeneralizedTransactionSet build() {
            GeneralizedTransactionSet val = new GeneralizedTransactionSet();
            val.setDiscriminant(this.discriminant);
            val.setV1TxSet(this.v1TxSet);
            return val;
        }
    }
}

