/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.ContractIDPreimage;
import org.stellar.sdk.xdr.EnvelopeType;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.PoolID;
import org.stellar.sdk.xdr.SequenceNumber;
import org.stellar.sdk.xdr.SorobanAuthorizedInvocation;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class HashIDPreimage
implements XdrElement {
    EnvelopeType type;
    private HashIDPreimageOperationID operationID;
    private HashIDPreimageRevokeID revokeID;
    private HashIDPreimageContractID contractID;
    private HashIDPreimageSorobanAuthorization sorobanAuthorization;

    public EnvelopeType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(EnvelopeType value) {
        this.type = value;
    }

    public HashIDPreimageOperationID getOperationID() {
        return this.operationID;
    }

    public void setOperationID(HashIDPreimageOperationID value) {
        this.operationID = value;
    }

    public HashIDPreimageRevokeID getRevokeID() {
        return this.revokeID;
    }

    public void setRevokeID(HashIDPreimageRevokeID value) {
        this.revokeID = value;
    }

    public HashIDPreimageContractID getContractID() {
        return this.contractID;
    }

    public void setContractID(HashIDPreimageContractID value) {
        this.contractID = value;
    }

    public HashIDPreimageSorobanAuthorization getSorobanAuthorization() {
        return this.sorobanAuthorization;
    }

    public void setSorobanAuthorization(HashIDPreimageSorobanAuthorization value) {
        this.sorobanAuthorization = value;
    }

    public static void encode(XdrDataOutputStream stream, HashIDPreimage encodedHashIDPreimage) throws IOException {
        stream.writeInt(encodedHashIDPreimage.getDiscriminant().getValue());
        switch (encodedHashIDPreimage.getDiscriminant()) {
            case ENVELOPE_TYPE_OP_ID: {
                HashIDPreimageOperationID.encode(stream, encodedHashIDPreimage.operationID);
                break;
            }
            case ENVELOPE_TYPE_POOL_REVOKE_OP_ID: {
                HashIDPreimageRevokeID.encode(stream, encodedHashIDPreimage.revokeID);
                break;
            }
            case ENVELOPE_TYPE_CONTRACT_ID: {
                HashIDPreimageContractID.encode(stream, encodedHashIDPreimage.contractID);
                break;
            }
            case ENVELOPE_TYPE_SOROBAN_AUTHORIZATION: {
                HashIDPreimageSorobanAuthorization.encode(stream, encodedHashIDPreimage.sorobanAuthorization);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        HashIDPreimage.encode(stream, this);
    }

    public static HashIDPreimage decode(XdrDataInputStream stream) throws IOException {
        HashIDPreimage decodedHashIDPreimage = new HashIDPreimage();
        EnvelopeType discriminant = EnvelopeType.decode(stream);
        decodedHashIDPreimage.setDiscriminant(discriminant);
        switch (decodedHashIDPreimage.getDiscriminant()) {
            case ENVELOPE_TYPE_OP_ID: {
                decodedHashIDPreimage.operationID = HashIDPreimageOperationID.decode(stream);
                break;
            }
            case ENVELOPE_TYPE_POOL_REVOKE_OP_ID: {
                decodedHashIDPreimage.revokeID = HashIDPreimageRevokeID.decode(stream);
                break;
            }
            case ENVELOPE_TYPE_CONTRACT_ID: {
                decodedHashIDPreimage.contractID = HashIDPreimageContractID.decode(stream);
                break;
            }
            case ENVELOPE_TYPE_SOROBAN_AUTHORIZATION: {
                decodedHashIDPreimage.sorobanAuthorization = HashIDPreimageSorobanAuthorization.decode(stream);
            }
        }
        return decodedHashIDPreimage;
    }

    public int hashCode() {
        return Objects.hash(this.operationID, this.revokeID, this.contractID, this.sorobanAuthorization, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof HashIDPreimage)) {
            return false;
        }
        HashIDPreimage other = (HashIDPreimage)object;
        return Objects.equals(this.operationID, other.operationID) && Objects.equals(this.revokeID, other.revokeID) && Objects.equals(this.contractID, other.contractID) && Objects.equals(this.sorobanAuthorization, other.sorobanAuthorization) && Objects.equals(this.type, other.type);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static HashIDPreimage fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return HashIDPreimage.fromXdrByteArray(bytes);
    }

    public static HashIDPreimage fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return HashIDPreimage.decode(xdrDataInputStream);
    }

    public static class HashIDPreimageOperationID
    implements XdrElement {
        private AccountID sourceAccount;
        private SequenceNumber seqNum;
        private Uint32 opNum;

        public AccountID getSourceAccount() {
            return this.sourceAccount;
        }

        public void setSourceAccount(AccountID value) {
            this.sourceAccount = value;
        }

        public SequenceNumber getSeqNum() {
            return this.seqNum;
        }

        public void setSeqNum(SequenceNumber value) {
            this.seqNum = value;
        }

        public Uint32 getOpNum() {
            return this.opNum;
        }

        public void setOpNum(Uint32 value) {
            this.opNum = value;
        }

        public static void encode(XdrDataOutputStream stream, HashIDPreimageOperationID encodedHashIDPreimageOperationID) throws IOException {
            AccountID.encode(stream, encodedHashIDPreimageOperationID.sourceAccount);
            SequenceNumber.encode(stream, encodedHashIDPreimageOperationID.seqNum);
            Uint32.encode(stream, encodedHashIDPreimageOperationID.opNum);
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            HashIDPreimageOperationID.encode(stream, this);
        }

        public static HashIDPreimageOperationID decode(XdrDataInputStream stream) throws IOException {
            HashIDPreimageOperationID decodedHashIDPreimageOperationID = new HashIDPreimageOperationID();
            decodedHashIDPreimageOperationID.sourceAccount = AccountID.decode(stream);
            decodedHashIDPreimageOperationID.seqNum = SequenceNumber.decode(stream);
            decodedHashIDPreimageOperationID.opNum = Uint32.decode(stream);
            return decodedHashIDPreimageOperationID;
        }

        public int hashCode() {
            return Objects.hash(this.sourceAccount, this.seqNum, this.opNum);
        }

        public boolean equals(Object object) {
            if (!(object instanceof HashIDPreimageOperationID)) {
                return false;
            }
            HashIDPreimageOperationID other = (HashIDPreimageOperationID)object;
            return Objects.equals(this.sourceAccount, other.sourceAccount) && Objects.equals(this.seqNum, other.seqNum) && Objects.equals(this.opNum, other.opNum);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static HashIDPreimageOperationID fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return HashIDPreimageOperationID.fromXdrByteArray(bytes);
        }

        public static HashIDPreimageOperationID fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return HashIDPreimageOperationID.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private AccountID sourceAccount;
            private SequenceNumber seqNum;
            private Uint32 opNum;

            public Builder sourceAccount(AccountID sourceAccount) {
                this.sourceAccount = sourceAccount;
                return this;
            }

            public Builder seqNum(SequenceNumber seqNum) {
                this.seqNum = seqNum;
                return this;
            }

            public Builder opNum(Uint32 opNum) {
                this.opNum = opNum;
                return this;
            }

            public HashIDPreimageOperationID build() {
                HashIDPreimageOperationID val = new HashIDPreimageOperationID();
                val.setSourceAccount(this.sourceAccount);
                val.setSeqNum(this.seqNum);
                val.setOpNum(this.opNum);
                return val;
            }
        }
    }

    public static class HashIDPreimageRevokeID
    implements XdrElement {
        private AccountID sourceAccount;
        private SequenceNumber seqNum;
        private Uint32 opNum;
        private PoolID liquidityPoolID;
        private Asset asset;

        public AccountID getSourceAccount() {
            return this.sourceAccount;
        }

        public void setSourceAccount(AccountID value) {
            this.sourceAccount = value;
        }

        public SequenceNumber getSeqNum() {
            return this.seqNum;
        }

        public void setSeqNum(SequenceNumber value) {
            this.seqNum = value;
        }

        public Uint32 getOpNum() {
            return this.opNum;
        }

        public void setOpNum(Uint32 value) {
            this.opNum = value;
        }

        public PoolID getLiquidityPoolID() {
            return this.liquidityPoolID;
        }

        public void setLiquidityPoolID(PoolID value) {
            this.liquidityPoolID = value;
        }

        public Asset getAsset() {
            return this.asset;
        }

        public void setAsset(Asset value) {
            this.asset = value;
        }

        public static void encode(XdrDataOutputStream stream, HashIDPreimageRevokeID encodedHashIDPreimageRevokeID) throws IOException {
            AccountID.encode(stream, encodedHashIDPreimageRevokeID.sourceAccount);
            SequenceNumber.encode(stream, encodedHashIDPreimageRevokeID.seqNum);
            Uint32.encode(stream, encodedHashIDPreimageRevokeID.opNum);
            PoolID.encode(stream, encodedHashIDPreimageRevokeID.liquidityPoolID);
            Asset.encode(stream, encodedHashIDPreimageRevokeID.asset);
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            HashIDPreimageRevokeID.encode(stream, this);
        }

        public static HashIDPreimageRevokeID decode(XdrDataInputStream stream) throws IOException {
            HashIDPreimageRevokeID decodedHashIDPreimageRevokeID = new HashIDPreimageRevokeID();
            decodedHashIDPreimageRevokeID.sourceAccount = AccountID.decode(stream);
            decodedHashIDPreimageRevokeID.seqNum = SequenceNumber.decode(stream);
            decodedHashIDPreimageRevokeID.opNum = Uint32.decode(stream);
            decodedHashIDPreimageRevokeID.liquidityPoolID = PoolID.decode(stream);
            decodedHashIDPreimageRevokeID.asset = Asset.decode(stream);
            return decodedHashIDPreimageRevokeID;
        }

        public int hashCode() {
            return Objects.hash(this.sourceAccount, this.seqNum, this.opNum, this.liquidityPoolID, this.asset);
        }

        public boolean equals(Object object) {
            if (!(object instanceof HashIDPreimageRevokeID)) {
                return false;
            }
            HashIDPreimageRevokeID other = (HashIDPreimageRevokeID)object;
            return Objects.equals(this.sourceAccount, other.sourceAccount) && Objects.equals(this.seqNum, other.seqNum) && Objects.equals(this.opNum, other.opNum) && Objects.equals(this.liquidityPoolID, other.liquidityPoolID) && Objects.equals(this.asset, other.asset);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static HashIDPreimageRevokeID fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return HashIDPreimageRevokeID.fromXdrByteArray(bytes);
        }

        public static HashIDPreimageRevokeID fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return HashIDPreimageRevokeID.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private AccountID sourceAccount;
            private SequenceNumber seqNum;
            private Uint32 opNum;
            private PoolID liquidityPoolID;
            private Asset asset;

            public Builder sourceAccount(AccountID sourceAccount) {
                this.sourceAccount = sourceAccount;
                return this;
            }

            public Builder seqNum(SequenceNumber seqNum) {
                this.seqNum = seqNum;
                return this;
            }

            public Builder opNum(Uint32 opNum) {
                this.opNum = opNum;
                return this;
            }

            public Builder liquidityPoolID(PoolID liquidityPoolID) {
                this.liquidityPoolID = liquidityPoolID;
                return this;
            }

            public Builder asset(Asset asset) {
                this.asset = asset;
                return this;
            }

            public HashIDPreimageRevokeID build() {
                HashIDPreimageRevokeID val = new HashIDPreimageRevokeID();
                val.setSourceAccount(this.sourceAccount);
                val.setSeqNum(this.seqNum);
                val.setOpNum(this.opNum);
                val.setLiquidityPoolID(this.liquidityPoolID);
                val.setAsset(this.asset);
                return val;
            }
        }
    }

    public static class HashIDPreimageContractID
    implements XdrElement {
        private Hash networkID;
        private ContractIDPreimage contractIDPreimage;

        public Hash getNetworkID() {
            return this.networkID;
        }

        public void setNetworkID(Hash value) {
            this.networkID = value;
        }

        public ContractIDPreimage getContractIDPreimage() {
            return this.contractIDPreimage;
        }

        public void setContractIDPreimage(ContractIDPreimage value) {
            this.contractIDPreimage = value;
        }

        public static void encode(XdrDataOutputStream stream, HashIDPreimageContractID encodedHashIDPreimageContractID) throws IOException {
            Hash.encode(stream, encodedHashIDPreimageContractID.networkID);
            ContractIDPreimage.encode(stream, encodedHashIDPreimageContractID.contractIDPreimage);
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            HashIDPreimageContractID.encode(stream, this);
        }

        public static HashIDPreimageContractID decode(XdrDataInputStream stream) throws IOException {
            HashIDPreimageContractID decodedHashIDPreimageContractID = new HashIDPreimageContractID();
            decodedHashIDPreimageContractID.networkID = Hash.decode(stream);
            decodedHashIDPreimageContractID.contractIDPreimage = ContractIDPreimage.decode(stream);
            return decodedHashIDPreimageContractID;
        }

        public int hashCode() {
            return Objects.hash(this.networkID, this.contractIDPreimage);
        }

        public boolean equals(Object object) {
            if (!(object instanceof HashIDPreimageContractID)) {
                return false;
            }
            HashIDPreimageContractID other = (HashIDPreimageContractID)object;
            return Objects.equals(this.networkID, other.networkID) && Objects.equals(this.contractIDPreimage, other.contractIDPreimage);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static HashIDPreimageContractID fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return HashIDPreimageContractID.fromXdrByteArray(bytes);
        }

        public static HashIDPreimageContractID fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return HashIDPreimageContractID.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private Hash networkID;
            private ContractIDPreimage contractIDPreimage;

            public Builder networkID(Hash networkID) {
                this.networkID = networkID;
                return this;
            }

            public Builder contractIDPreimage(ContractIDPreimage contractIDPreimage) {
                this.contractIDPreimage = contractIDPreimage;
                return this;
            }

            public HashIDPreimageContractID build() {
                HashIDPreimageContractID val = new HashIDPreimageContractID();
                val.setNetworkID(this.networkID);
                val.setContractIDPreimage(this.contractIDPreimage);
                return val;
            }
        }
    }

    public static class HashIDPreimageSorobanAuthorization
    implements XdrElement {
        private Hash networkID;
        private Int64 nonce;
        private Uint32 signatureExpirationLedger;
        private SorobanAuthorizedInvocation invocation;

        public Hash getNetworkID() {
            return this.networkID;
        }

        public void setNetworkID(Hash value) {
            this.networkID = value;
        }

        public Int64 getNonce() {
            return this.nonce;
        }

        public void setNonce(Int64 value) {
            this.nonce = value;
        }

        public Uint32 getSignatureExpirationLedger() {
            return this.signatureExpirationLedger;
        }

        public void setSignatureExpirationLedger(Uint32 value) {
            this.signatureExpirationLedger = value;
        }

        public SorobanAuthorizedInvocation getInvocation() {
            return this.invocation;
        }

        public void setInvocation(SorobanAuthorizedInvocation value) {
            this.invocation = value;
        }

        public static void encode(XdrDataOutputStream stream, HashIDPreimageSorobanAuthorization encodedHashIDPreimageSorobanAuthorization) throws IOException {
            Hash.encode(stream, encodedHashIDPreimageSorobanAuthorization.networkID);
            Int64.encode(stream, encodedHashIDPreimageSorobanAuthorization.nonce);
            Uint32.encode(stream, encodedHashIDPreimageSorobanAuthorization.signatureExpirationLedger);
            SorobanAuthorizedInvocation.encode(stream, encodedHashIDPreimageSorobanAuthorization.invocation);
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            HashIDPreimageSorobanAuthorization.encode(stream, this);
        }

        public static HashIDPreimageSorobanAuthorization decode(XdrDataInputStream stream) throws IOException {
            HashIDPreimageSorobanAuthorization decodedHashIDPreimageSorobanAuthorization = new HashIDPreimageSorobanAuthorization();
            decodedHashIDPreimageSorobanAuthorization.networkID = Hash.decode(stream);
            decodedHashIDPreimageSorobanAuthorization.nonce = Int64.decode(stream);
            decodedHashIDPreimageSorobanAuthorization.signatureExpirationLedger = Uint32.decode(stream);
            decodedHashIDPreimageSorobanAuthorization.invocation = SorobanAuthorizedInvocation.decode(stream);
            return decodedHashIDPreimageSorobanAuthorization;
        }

        public int hashCode() {
            return Objects.hash(this.networkID, this.nonce, this.signatureExpirationLedger, this.invocation);
        }

        public boolean equals(Object object) {
            if (!(object instanceof HashIDPreimageSorobanAuthorization)) {
                return false;
            }
            HashIDPreimageSorobanAuthorization other = (HashIDPreimageSorobanAuthorization)object;
            return Objects.equals(this.networkID, other.networkID) && Objects.equals(this.nonce, other.nonce) && Objects.equals(this.signatureExpirationLedger, other.signatureExpirationLedger) && Objects.equals(this.invocation, other.invocation);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static HashIDPreimageSorobanAuthorization fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return HashIDPreimageSorobanAuthorization.fromXdrByteArray(bytes);
        }

        public static HashIDPreimageSorobanAuthorization fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return HashIDPreimageSorobanAuthorization.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private Hash networkID;
            private Int64 nonce;
            private Uint32 signatureExpirationLedger;
            private SorobanAuthorizedInvocation invocation;

            public Builder networkID(Hash networkID) {
                this.networkID = networkID;
                return this;
            }

            public Builder nonce(Int64 nonce) {
                this.nonce = nonce;
                return this;
            }

            public Builder signatureExpirationLedger(Uint32 signatureExpirationLedger) {
                this.signatureExpirationLedger = signatureExpirationLedger;
                return this;
            }

            public Builder invocation(SorobanAuthorizedInvocation invocation) {
                this.invocation = invocation;
                return this;
            }

            public HashIDPreimageSorobanAuthorization build() {
                HashIDPreimageSorobanAuthorization val = new HashIDPreimageSorobanAuthorization();
                val.setNetworkID(this.networkID);
                val.setNonce(this.nonce);
                val.setSignatureExpirationLedger(this.signatureExpirationLedger);
                val.setInvocation(this.invocation);
                return val;
            }
        }
    }

    public static final class Builder {
        private EnvelopeType discriminant;
        private HashIDPreimageOperationID operationID;
        private HashIDPreimageRevokeID revokeID;
        private HashIDPreimageContractID contractID;
        private HashIDPreimageSorobanAuthorization sorobanAuthorization;

        public Builder discriminant(EnvelopeType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder operationID(HashIDPreimageOperationID operationID) {
            this.operationID = operationID;
            return this;
        }

        public Builder revokeID(HashIDPreimageRevokeID revokeID) {
            this.revokeID = revokeID;
            return this;
        }

        public Builder contractID(HashIDPreimageContractID contractID) {
            this.contractID = contractID;
            return this;
        }

        public Builder sorobanAuthorization(HashIDPreimageSorobanAuthorization sorobanAuthorization) {
            this.sorobanAuthorization = sorobanAuthorization;
            return this;
        }

        public HashIDPreimage build() {
            HashIDPreimage val = new HashIDPreimage();
            val.setDiscriminant(this.discriminant);
            val.setOperationID(this.operationID);
            val.setRevokeID(this.revokeID);
            val.setContractID(this.contractID);
            val.setSorobanAuthorization(this.sorobanAuthorization);
            return val;
        }
    }
}

