/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AuthCert;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.NodeID;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import org.stellar.sdk.xdr.XdrString;

public class Hello
implements XdrElement {
    private Uint32 ledgerVersion;
    private Uint32 overlayVersion;
    private Uint32 overlayMinVersion;
    private Hash networkID;
    private XdrString versionStr;
    private Integer listeningPort;
    private NodeID peerID;
    private AuthCert cert;
    private Uint256 nonce;

    public Uint32 getLedgerVersion() {
        return this.ledgerVersion;
    }

    public void setLedgerVersion(Uint32 value) {
        this.ledgerVersion = value;
    }

    public Uint32 getOverlayVersion() {
        return this.overlayVersion;
    }

    public void setOverlayVersion(Uint32 value) {
        this.overlayVersion = value;
    }

    public Uint32 getOverlayMinVersion() {
        return this.overlayMinVersion;
    }

    public void setOverlayMinVersion(Uint32 value) {
        this.overlayMinVersion = value;
    }

    public Hash getNetworkID() {
        return this.networkID;
    }

    public void setNetworkID(Hash value) {
        this.networkID = value;
    }

    public XdrString getVersionStr() {
        return this.versionStr;
    }

    public void setVersionStr(XdrString value) {
        this.versionStr = value;
    }

    public Integer getListeningPort() {
        return this.listeningPort;
    }

    public void setListeningPort(Integer value) {
        this.listeningPort = value;
    }

    public NodeID getPeerID() {
        return this.peerID;
    }

    public void setPeerID(NodeID value) {
        this.peerID = value;
    }

    public AuthCert getCert() {
        return this.cert;
    }

    public void setCert(AuthCert value) {
        this.cert = value;
    }

    public Uint256 getNonce() {
        return this.nonce;
    }

    public void setNonce(Uint256 value) {
        this.nonce = value;
    }

    public static void encode(XdrDataOutputStream stream, Hello encodedHello) throws IOException {
        Uint32.encode(stream, encodedHello.ledgerVersion);
        Uint32.encode(stream, encodedHello.overlayVersion);
        Uint32.encode(stream, encodedHello.overlayMinVersion);
        Hash.encode(stream, encodedHello.networkID);
        encodedHello.versionStr.encode(stream);
        stream.writeInt(encodedHello.listeningPort);
        NodeID.encode(stream, encodedHello.peerID);
        AuthCert.encode(stream, encodedHello.cert);
        Uint256.encode(stream, encodedHello.nonce);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        Hello.encode(stream, this);
    }

    public static Hello decode(XdrDataInputStream stream) throws IOException {
        Hello decodedHello = new Hello();
        decodedHello.ledgerVersion = Uint32.decode(stream);
        decodedHello.overlayVersion = Uint32.decode(stream);
        decodedHello.overlayMinVersion = Uint32.decode(stream);
        decodedHello.networkID = Hash.decode(stream);
        decodedHello.versionStr = XdrString.decode(stream, 100);
        decodedHello.listeningPort = stream.readInt();
        decodedHello.peerID = NodeID.decode(stream);
        decodedHello.cert = AuthCert.decode(stream);
        decodedHello.nonce = Uint256.decode(stream);
        return decodedHello;
    }

    public int hashCode() {
        return Objects.hash(this.ledgerVersion, this.overlayVersion, this.overlayMinVersion, this.networkID, this.versionStr, this.listeningPort, this.peerID, this.cert, this.nonce);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Hello)) {
            return false;
        }
        Hello other = (Hello)object;
        return Objects.equals(this.ledgerVersion, other.ledgerVersion) && Objects.equals(this.overlayVersion, other.overlayVersion) && Objects.equals(this.overlayMinVersion, other.overlayMinVersion) && Objects.equals(this.networkID, other.networkID) && Objects.equals(this.versionStr, other.versionStr) && Objects.equals(this.listeningPort, other.listeningPort) && Objects.equals(this.peerID, other.peerID) && Objects.equals(this.cert, other.cert) && Objects.equals(this.nonce, other.nonce);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Hello fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Hello.fromXdrByteArray(bytes);
    }

    public static Hello fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Hello.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Uint32 ledgerVersion;
        private Uint32 overlayVersion;
        private Uint32 overlayMinVersion;
        private Hash networkID;
        private XdrString versionStr;
        private Integer listeningPort;
        private NodeID peerID;
        private AuthCert cert;
        private Uint256 nonce;

        public Builder ledgerVersion(Uint32 ledgerVersion) {
            this.ledgerVersion = ledgerVersion;
            return this;
        }

        public Builder overlayVersion(Uint32 overlayVersion) {
            this.overlayVersion = overlayVersion;
            return this;
        }

        public Builder overlayMinVersion(Uint32 overlayMinVersion) {
            this.overlayMinVersion = overlayMinVersion;
            return this;
        }

        public Builder networkID(Hash networkID) {
            this.networkID = networkID;
            return this;
        }

        public Builder versionStr(XdrString versionStr) {
            this.versionStr = versionStr;
            return this;
        }

        public Builder listeningPort(Integer listeningPort) {
            this.listeningPort = listeningPort;
            return this;
        }

        public Builder peerID(NodeID peerID) {
            this.peerID = peerID;
            return this;
        }

        public Builder cert(AuthCert cert) {
            this.cert = cert;
            return this;
        }

        public Builder nonce(Uint256 nonce) {
            this.nonce = nonce;
            return this;
        }

        public Hello build() {
            Hello val = new Hello();
            val.setLedgerVersion(this.ledgerVersion);
            val.setOverlayVersion(this.overlayVersion);
            val.setOverlayMinVersion(this.overlayMinVersion);
            val.setNetworkID(this.networkID);
            val.setVersionStr(this.versionStr);
            val.setListeningPort(this.listeningPort);
            val.setPeerID(this.peerID);
            val.setCert(this.cert);
            val.setNonce(this.nonce);
            return val;
        }
    }
}

