/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum HostFunctionType implements XdrElement
{
    HOST_FUNCTION_TYPE_INVOKE_CONTRACT(0),
    HOST_FUNCTION_TYPE_CREATE_CONTRACT(1),
    HOST_FUNCTION_TYPE_UPLOAD_CONTRACT_WASM(2);

    private int mValue;

    private HostFunctionType(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static HostFunctionType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return HOST_FUNCTION_TYPE_INVOKE_CONTRACT;
            }
            case 1: {
                return HOST_FUNCTION_TYPE_CREATE_CONTRACT;
            }
            case 2: {
                return HOST_FUNCTION_TYPE_UPLOAD_CONTRACT_WASM;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, HostFunctionType value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        HostFunctionType.encode(stream, this);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static HostFunctionType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return HostFunctionType.fromXdrByteArray(bytes);
    }

    public static HostFunctionType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return HostFunctionType.decode(xdrDataInputStream);
    }
}

