/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum InvokeHostFunctionResultCode implements XdrElement
{
    INVOKE_HOST_FUNCTION_SUCCESS(0),
    INVOKE_HOST_FUNCTION_MALFORMED(-1),
    INVOKE_HOST_FUNCTION_TRAPPED(-2),
    INVOKE_HOST_FUNCTION_RESOURCE_LIMIT_EXCEEDED(-3),
    INVOKE_HOST_FUNCTION_ENTRY_ARCHIVED(-4),
    INVOKE_HOST_FUNCTION_INSUFFICIENT_REFUNDABLE_FEE(-5);

    private int mValue;

    private InvokeHostFunctionResultCode(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static InvokeHostFunctionResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return INVOKE_HOST_FUNCTION_SUCCESS;
            }
            case -1: {
                return INVOKE_HOST_FUNCTION_MALFORMED;
            }
            case -2: {
                return INVOKE_HOST_FUNCTION_TRAPPED;
            }
            case -3: {
                return INVOKE_HOST_FUNCTION_RESOURCE_LIMIT_EXCEEDED;
            }
            case -4: {
                return INVOKE_HOST_FUNCTION_ENTRY_ARCHIVED;
            }
            case -5: {
                return INVOKE_HOST_FUNCTION_INSUFFICIENT_REFUNDABLE_FEE;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, InvokeHostFunctionResultCode value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        InvokeHostFunctionResultCode.encode(stream, this);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static InvokeHostFunctionResultCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return InvokeHostFunctionResultCode.fromXdrByteArray(bytes);
    }

    public static InvokeHostFunctionResultCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return InvokeHostFunctionResultCode.decode(xdrDataInputStream);
    }
}

