/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum ManageSellOfferResultCode implements XdrElement
{
    MANAGE_SELL_OFFER_SUCCESS(0),
    MANAGE_SELL_OFFER_MALFORMED(-1),
    MANAGE_SELL_OFFER_SELL_NO_TRUST(-2),
    MANAGE_SELL_OFFER_BUY_NO_TRUST(-3),
    MANAGE_SELL_OFFER_SELL_NOT_AUTHORIZED(-4),
    MANAGE_SELL_OFFER_BUY_NOT_AUTHORIZED(-5),
    MANAGE_SELL_OFFER_LINE_FULL(-6),
    MANAGE_SELL_OFFER_UNDERFUNDED(-7),
    MANAGE_SELL_OFFER_CROSS_SELF(-8),
    MANAGE_SELL_OFFER_SELL_NO_ISSUER(-9),
    MANAGE_SELL_OFFER_BUY_NO_ISSUER(-10),
    MANAGE_SELL_OFFER_NOT_FOUND(-11),
    MANAGE_SELL_OFFER_LOW_RESERVE(-12);

    private int mValue;

    private ManageSellOfferResultCode(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static ManageSellOfferResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return MANAGE_SELL_OFFER_SUCCESS;
            }
            case -1: {
                return MANAGE_SELL_OFFER_MALFORMED;
            }
            case -2: {
                return MANAGE_SELL_OFFER_SELL_NO_TRUST;
            }
            case -3: {
                return MANAGE_SELL_OFFER_BUY_NO_TRUST;
            }
            case -4: {
                return MANAGE_SELL_OFFER_SELL_NOT_AUTHORIZED;
            }
            case -5: {
                return MANAGE_SELL_OFFER_BUY_NOT_AUTHORIZED;
            }
            case -6: {
                return MANAGE_SELL_OFFER_LINE_FULL;
            }
            case -7: {
                return MANAGE_SELL_OFFER_UNDERFUNDED;
            }
            case -8: {
                return MANAGE_SELL_OFFER_CROSS_SELF;
            }
            case -9: {
                return MANAGE_SELL_OFFER_SELL_NO_ISSUER;
            }
            case -10: {
                return MANAGE_SELL_OFFER_BUY_NO_ISSUER;
            }
            case -11: {
                return MANAGE_SELL_OFFER_NOT_FOUND;
            }
            case -12: {
                return MANAGE_SELL_OFFER_LOW_RESERVE;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, ManageSellOfferResultCode value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ManageSellOfferResultCode.encode(stream, this);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ManageSellOfferResultCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ManageSellOfferResultCode.fromXdrByteArray(bytes);
    }

    public static ManageSellOfferResultCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ManageSellOfferResultCode.decode(xdrDataInputStream);
    }
}

