/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.LedgerEntryChanges;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class OperationMeta
implements XdrElement {
    private LedgerEntryChanges changes;

    public LedgerEntryChanges getChanges() {
        return this.changes;
    }

    public void setChanges(LedgerEntryChanges value) {
        this.changes = value;
    }

    public static void encode(XdrDataOutputStream stream, OperationMeta encodedOperationMeta) throws IOException {
        LedgerEntryChanges.encode(stream, encodedOperationMeta.changes);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        OperationMeta.encode(stream, this);
    }

    public static OperationMeta decode(XdrDataInputStream stream) throws IOException {
        OperationMeta decodedOperationMeta = new OperationMeta();
        decodedOperationMeta.changes = LedgerEntryChanges.decode(stream);
        return decodedOperationMeta;
    }

    public int hashCode() {
        return Objects.hash(this.changes);
    }

    public boolean equals(Object object) {
        if (!(object instanceof OperationMeta)) {
            return false;
        }
        OperationMeta other = (OperationMeta)object;
        return Objects.equals(this.changes, other.changes);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static OperationMeta fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return OperationMeta.fromXdrByteArray(bytes);
    }

    public static OperationMeta fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return OperationMeta.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private LedgerEntryChanges changes;

        public Builder changes(LedgerEntryChanges changes) {
            this.changes = changes;
            return this;
        }

        public OperationMeta build() {
            OperationMeta val = new OperationMeta();
            val.setChanges(this.changes);
            return val;
        }
    }
}

