/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum PathPaymentStrictReceiveResultCode implements XdrElement
{
    PATH_PAYMENT_STRICT_RECEIVE_SUCCESS(0),
    PATH_PAYMENT_STRICT_RECEIVE_MALFORMED(-1),
    PATH_PAYMENT_STRICT_RECEIVE_UNDERFUNDED(-2),
    PATH_PAYMENT_STRICT_RECEIVE_SRC_NO_TRUST(-3),
    PATH_PAYMENT_STRICT_RECEIVE_SRC_NOT_AUTHORIZED(-4),
    PATH_PAYMENT_STRICT_RECEIVE_NO_DESTINATION(-5),
    PATH_PAYMENT_STRICT_RECEIVE_NO_TRUST(-6),
    PATH_PAYMENT_STRICT_RECEIVE_NOT_AUTHORIZED(-7),
    PATH_PAYMENT_STRICT_RECEIVE_LINE_FULL(-8),
    PATH_PAYMENT_STRICT_RECEIVE_NO_ISSUER(-9),
    PATH_PAYMENT_STRICT_RECEIVE_TOO_FEW_OFFERS(-10),
    PATH_PAYMENT_STRICT_RECEIVE_OFFER_CROSS_SELF(-11),
    PATH_PAYMENT_STRICT_RECEIVE_OVER_SENDMAX(-12);

    private int mValue;

    private PathPaymentStrictReceiveResultCode(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static PathPaymentStrictReceiveResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return PATH_PAYMENT_STRICT_RECEIVE_SUCCESS;
            }
            case -1: {
                return PATH_PAYMENT_STRICT_RECEIVE_MALFORMED;
            }
            case -2: {
                return PATH_PAYMENT_STRICT_RECEIVE_UNDERFUNDED;
            }
            case -3: {
                return PATH_PAYMENT_STRICT_RECEIVE_SRC_NO_TRUST;
            }
            case -4: {
                return PATH_PAYMENT_STRICT_RECEIVE_SRC_NOT_AUTHORIZED;
            }
            case -5: {
                return PATH_PAYMENT_STRICT_RECEIVE_NO_DESTINATION;
            }
            case -6: {
                return PATH_PAYMENT_STRICT_RECEIVE_NO_TRUST;
            }
            case -7: {
                return PATH_PAYMENT_STRICT_RECEIVE_NOT_AUTHORIZED;
            }
            case -8: {
                return PATH_PAYMENT_STRICT_RECEIVE_LINE_FULL;
            }
            case -9: {
                return PATH_PAYMENT_STRICT_RECEIVE_NO_ISSUER;
            }
            case -10: {
                return PATH_PAYMENT_STRICT_RECEIVE_TOO_FEW_OFFERS;
            }
            case -11: {
                return PATH_PAYMENT_STRICT_RECEIVE_OFFER_CROSS_SELF;
            }
            case -12: {
                return PATH_PAYMENT_STRICT_RECEIVE_OVER_SENDMAX;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, PathPaymentStrictReceiveResultCode value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        PathPaymentStrictReceiveResultCode.encode(stream, this);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static PathPaymentStrictReceiveResultCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return PathPaymentStrictReceiveResultCode.fromXdrByteArray(bytes);
    }

    public static PathPaymentStrictReceiveResultCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return PathPaymentStrictReceiveResultCode.decode(xdrDataInputStream);
    }
}

