/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.PaymentResultCode;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class PaymentResult
implements XdrElement {
    PaymentResultCode code;

    public PaymentResultCode getDiscriminant() {
        return this.code;
    }

    public void setDiscriminant(PaymentResultCode value) {
        this.code = value;
    }

    public static void encode(XdrDataOutputStream stream, PaymentResult encodedPaymentResult) throws IOException {
        stream.writeInt(encodedPaymentResult.getDiscriminant().getValue());
        switch (encodedPaymentResult.getDiscriminant()) {
            case PAYMENT_SUCCESS: {
                break;
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        PaymentResult.encode(stream, this);
    }

    public static PaymentResult decode(XdrDataInputStream stream) throws IOException {
        PaymentResult decodedPaymentResult = new PaymentResult();
        PaymentResultCode discriminant = PaymentResultCode.decode(stream);
        decodedPaymentResult.setDiscriminant(discriminant);
        switch (decodedPaymentResult.getDiscriminant()) {
            case PAYMENT_SUCCESS: {
                break;
            }
        }
        return decodedPaymentResult;
    }

    public int hashCode() {
        return Objects.hash(this.code);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PaymentResult)) {
            return false;
        }
        PaymentResult other = (PaymentResult)object;
        return Objects.equals(this.code, other.code);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static PaymentResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return PaymentResult.fromXdrByteArray(bytes);
    }

    public static PaymentResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return PaymentResult.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private PaymentResultCode discriminant;

        public Builder discriminant(PaymentResultCode discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public PaymentResult build() {
            PaymentResult val = new PaymentResult();
            val.setDiscriminant(this.discriminant);
            return val;
        }
    }
}

