/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Int32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class Price
implements XdrElement {
    private Int32 n;
    private Int32 d;

    public Int32 getN() {
        return this.n;
    }

    public void setN(Int32 value) {
        this.n = value;
    }

    public Int32 getD() {
        return this.d;
    }

    public void setD(Int32 value) {
        this.d = value;
    }

    public static void encode(XdrDataOutputStream stream, Price encodedPrice) throws IOException {
        Int32.encode(stream, encodedPrice.n);
        Int32.encode(stream, encodedPrice.d);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        Price.encode(stream, this);
    }

    public static Price decode(XdrDataInputStream stream) throws IOException {
        Price decodedPrice = new Price();
        decodedPrice.n = Int32.decode(stream);
        decodedPrice.d = Int32.decode(stream);
        return decodedPrice;
    }

    public int hashCode() {
        return Objects.hash(this.n, this.d);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Price)) {
            return false;
        }
        Price other = (Price)object;
        return Objects.equals(this.n, other.n) && Objects.equals(this.d, other.d);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Price fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Price.fromXdrByteArray(bytes);
    }

    public static Price fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Price.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Int32 n;
        private Int32 d;

        public Builder n(Int32 n) {
            this.n = n;
            return this;
        }

        public Builder d(Int32 d) {
            this.d = d;
            return this;
        }

        public Price build() {
            Price val = new Price();
            val.setN(this.n);
            val.setD(this.d);
            return val;
        }
    }
}

