/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.SCAddressType;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCAddress
implements XdrElement {
    SCAddressType type;
    private AccountID accountId;
    private Hash contractId;

    public SCAddressType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(SCAddressType value) {
        this.type = value;
    }

    public AccountID getAccountId() {
        return this.accountId;
    }

    public void setAccountId(AccountID value) {
        this.accountId = value;
    }

    public Hash getContractId() {
        return this.contractId;
    }

    public void setContractId(Hash value) {
        this.contractId = value;
    }

    public static void encode(XdrDataOutputStream stream, SCAddress encodedSCAddress) throws IOException {
        stream.writeInt(encodedSCAddress.getDiscriminant().getValue());
        switch (encodedSCAddress.getDiscriminant()) {
            case SC_ADDRESS_TYPE_ACCOUNT: {
                AccountID.encode(stream, encodedSCAddress.accountId);
                break;
            }
            case SC_ADDRESS_TYPE_CONTRACT: {
                Hash.encode(stream, encodedSCAddress.contractId);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCAddress.encode(stream, this);
    }

    public static SCAddress decode(XdrDataInputStream stream) throws IOException {
        SCAddress decodedSCAddress = new SCAddress();
        SCAddressType discriminant = SCAddressType.decode(stream);
        decodedSCAddress.setDiscriminant(discriminant);
        switch (decodedSCAddress.getDiscriminant()) {
            case SC_ADDRESS_TYPE_ACCOUNT: {
                decodedSCAddress.accountId = AccountID.decode(stream);
                break;
            }
            case SC_ADDRESS_TYPE_CONTRACT: {
                decodedSCAddress.contractId = Hash.decode(stream);
            }
        }
        return decodedSCAddress;
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.contractId, this.type);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SCAddress)) {
            return false;
        }
        SCAddress other = (SCAddress)object;
        return Objects.equals(this.accountId, other.accountId) && Objects.equals(this.contractId, other.contractId) && Objects.equals(this.type, other.type);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SCAddress fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCAddress.fromXdrByteArray(bytes);
    }

    public static SCAddress fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCAddress.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private SCAddressType discriminant;
        private AccountID accountId;
        private Hash contractId;

        public Builder discriminant(SCAddressType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder accountId(AccountID accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder contractId(Hash contractId) {
            this.contractId = contractId;
            return this;
        }

        public SCAddress build() {
            SCAddress val = new SCAddress();
            val.setDiscriminant(this.discriminant);
            val.setAccountId(this.accountId);
            val.setContractId(this.contractId);
            return val;
        }
    }
}

