/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCEnvMetaKind;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCEnvMetaEntry
implements XdrElement {
    SCEnvMetaKind kind;
    private Uint64 interfaceVersion;

    public SCEnvMetaKind getDiscriminant() {
        return this.kind;
    }

    public void setDiscriminant(SCEnvMetaKind value) {
        this.kind = value;
    }

    public Uint64 getInterfaceVersion() {
        return this.interfaceVersion;
    }

    public void setInterfaceVersion(Uint64 value) {
        this.interfaceVersion = value;
    }

    public static void encode(XdrDataOutputStream stream, SCEnvMetaEntry encodedSCEnvMetaEntry) throws IOException {
        stream.writeInt(encodedSCEnvMetaEntry.getDiscriminant().getValue());
        switch (encodedSCEnvMetaEntry.getDiscriminant()) {
            case SC_ENV_META_KIND_INTERFACE_VERSION: {
                Uint64.encode(stream, encodedSCEnvMetaEntry.interfaceVersion);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCEnvMetaEntry.encode(stream, this);
    }

    public static SCEnvMetaEntry decode(XdrDataInputStream stream) throws IOException {
        SCEnvMetaEntry decodedSCEnvMetaEntry = new SCEnvMetaEntry();
        SCEnvMetaKind discriminant = SCEnvMetaKind.decode(stream);
        decodedSCEnvMetaEntry.setDiscriminant(discriminant);
        switch (decodedSCEnvMetaEntry.getDiscriminant()) {
            case SC_ENV_META_KIND_INTERFACE_VERSION: {
                decodedSCEnvMetaEntry.interfaceVersion = Uint64.decode(stream);
            }
        }
        return decodedSCEnvMetaEntry;
    }

    public int hashCode() {
        return Objects.hash(this.interfaceVersion, this.kind);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SCEnvMetaEntry)) {
            return false;
        }
        SCEnvMetaEntry other = (SCEnvMetaEntry)object;
        return Objects.equals(this.interfaceVersion, other.interfaceVersion) && Objects.equals(this.kind, other.kind);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SCEnvMetaEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCEnvMetaEntry.fromXdrByteArray(bytes);
    }

    public static SCEnvMetaEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCEnvMetaEntry.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private SCEnvMetaKind discriminant;
        private Uint64 interfaceVersion;

        public Builder discriminant(SCEnvMetaKind discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder interfaceVersion(Uint64 interfaceVersion) {
            this.interfaceVersion = interfaceVersion;
            return this;
        }

        public SCEnvMetaEntry build() {
            SCEnvMetaEntry val = new SCEnvMetaEntry();
            val.setDiscriminant(this.discriminant);
            val.setInterfaceVersion(this.interfaceVersion);
            return val;
        }
    }
}

