/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum SCErrorCode implements XdrElement
{
    SCEC_ARITH_DOMAIN(0),
    SCEC_INDEX_BOUNDS(1),
    SCEC_INVALID_INPUT(2),
    SCEC_MISSING_VALUE(3),
    SCEC_EXISTING_VALUE(4),
    SCEC_EXCEEDED_LIMIT(5),
    SCEC_INVALID_ACTION(6),
    SCEC_INTERNAL_ERROR(7),
    SCEC_UNEXPECTED_TYPE(8),
    SCEC_UNEXPECTED_SIZE(9);

    private int mValue;

    private SCErrorCode(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static SCErrorCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return SCEC_ARITH_DOMAIN;
            }
            case 1: {
                return SCEC_INDEX_BOUNDS;
            }
            case 2: {
                return SCEC_INVALID_INPUT;
            }
            case 3: {
                return SCEC_MISSING_VALUE;
            }
            case 4: {
                return SCEC_EXISTING_VALUE;
            }
            case 5: {
                return SCEC_EXCEEDED_LIMIT;
            }
            case 6: {
                return SCEC_INVALID_ACTION;
            }
            case 7: {
                return SCEC_INTERNAL_ERROR;
            }
            case 8: {
                return SCEC_UNEXPECTED_TYPE;
            }
            case 9: {
                return SCEC_UNEXPECTED_SIZE;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, SCErrorCode value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCErrorCode.encode(stream, this);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SCErrorCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCErrorCode.fromXdrByteArray(bytes);
    }

    public static SCErrorCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCErrorCode.decode(xdrDataInputStream);
    }
}

