/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCSpecFunctionInputV0;
import org.stellar.sdk.xdr.SCSpecTypeDef;
import org.stellar.sdk.xdr.SCSymbol;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import org.stellar.sdk.xdr.XdrString;

public class SCSpecFunctionV0
implements XdrElement {
    private XdrString doc;
    private SCSymbol name;
    private SCSpecFunctionInputV0[] inputs;
    private SCSpecTypeDef[] outputs;

    public XdrString getDoc() {
        return this.doc;
    }

    public void setDoc(XdrString value) {
        this.doc = value;
    }

    public SCSymbol getName() {
        return this.name;
    }

    public void setName(SCSymbol value) {
        this.name = value;
    }

    public SCSpecFunctionInputV0[] getInputs() {
        return this.inputs;
    }

    public void setInputs(SCSpecFunctionInputV0[] value) {
        this.inputs = value;
    }

    public SCSpecTypeDef[] getOutputs() {
        return this.outputs;
    }

    public void setOutputs(SCSpecTypeDef[] value) {
        this.outputs = value;
    }

    public static void encode(XdrDataOutputStream stream, SCSpecFunctionV0 encodedSCSpecFunctionV0) throws IOException {
        encodedSCSpecFunctionV0.doc.encode(stream);
        SCSymbol.encode(stream, encodedSCSpecFunctionV0.name);
        int inputssize = encodedSCSpecFunctionV0.getInputs().length;
        stream.writeInt(inputssize);
        for (int i = 0; i < inputssize; ++i) {
            SCSpecFunctionInputV0.encode(stream, encodedSCSpecFunctionV0.inputs[i]);
        }
        int outputssize = encodedSCSpecFunctionV0.getOutputs().length;
        stream.writeInt(outputssize);
        for (int i = 0; i < outputssize; ++i) {
            SCSpecTypeDef.encode(stream, encodedSCSpecFunctionV0.outputs[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCSpecFunctionV0.encode(stream, this);
    }

    public static SCSpecFunctionV0 decode(XdrDataInputStream stream) throws IOException {
        SCSpecFunctionV0 decodedSCSpecFunctionV0 = new SCSpecFunctionV0();
        decodedSCSpecFunctionV0.doc = XdrString.decode(stream, 1024);
        decodedSCSpecFunctionV0.name = SCSymbol.decode(stream);
        int inputssize = stream.readInt();
        decodedSCSpecFunctionV0.inputs = new SCSpecFunctionInputV0[inputssize];
        for (int i = 0; i < inputssize; ++i) {
            decodedSCSpecFunctionV0.inputs[i] = SCSpecFunctionInputV0.decode(stream);
        }
        int outputssize = stream.readInt();
        decodedSCSpecFunctionV0.outputs = new SCSpecTypeDef[outputssize];
        for (int i = 0; i < outputssize; ++i) {
            decodedSCSpecFunctionV0.outputs[i] = SCSpecTypeDef.decode(stream);
        }
        return decodedSCSpecFunctionV0;
    }

    public int hashCode() {
        return Objects.hash(this.doc, this.name, Arrays.hashCode(this.inputs), Arrays.hashCode(this.outputs));
    }

    public boolean equals(Object object) {
        if (!(object instanceof SCSpecFunctionV0)) {
            return false;
        }
        SCSpecFunctionV0 other = (SCSpecFunctionV0)object;
        return Objects.equals(this.doc, other.doc) && Objects.equals(this.name, other.name) && Arrays.equals(this.inputs, other.inputs) && Arrays.equals(this.outputs, other.outputs);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SCSpecFunctionV0 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCSpecFunctionV0.fromXdrByteArray(bytes);
    }

    public static SCSpecFunctionV0 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCSpecFunctionV0.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private XdrString doc;
        private SCSymbol name;
        private SCSpecFunctionInputV0[] inputs;
        private SCSpecTypeDef[] outputs;

        public Builder doc(XdrString doc) {
            this.doc = doc;
            return this;
        }

        public Builder name(SCSymbol name) {
            this.name = name;
            return this;
        }

        public Builder inputs(SCSpecFunctionInputV0[] inputs) {
            this.inputs = inputs;
            return this;
        }

        public Builder outputs(SCSpecTypeDef[] outputs) {
            this.outputs = outputs;
            return this;
        }

        public SCSpecFunctionV0 build() {
            SCSpecFunctionV0 val = new SCSpecFunctionV0();
            val.setDoc(this.doc);
            val.setName(this.name);
            val.setInputs(this.inputs);
            val.setOutputs(this.outputs);
            return val;
        }
    }
}

