/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCSpecTypeDef;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCSpecTypeResult
implements XdrElement {
    private SCSpecTypeDef okType;
    private SCSpecTypeDef errorType;

    public SCSpecTypeDef getOkType() {
        return this.okType;
    }

    public void setOkType(SCSpecTypeDef value) {
        this.okType = value;
    }

    public SCSpecTypeDef getErrorType() {
        return this.errorType;
    }

    public void setErrorType(SCSpecTypeDef value) {
        this.errorType = value;
    }

    public static void encode(XdrDataOutputStream stream, SCSpecTypeResult encodedSCSpecTypeResult) throws IOException {
        SCSpecTypeDef.encode(stream, encodedSCSpecTypeResult.okType);
        SCSpecTypeDef.encode(stream, encodedSCSpecTypeResult.errorType);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCSpecTypeResult.encode(stream, this);
    }

    public static SCSpecTypeResult decode(XdrDataInputStream stream) throws IOException {
        SCSpecTypeResult decodedSCSpecTypeResult = new SCSpecTypeResult();
        decodedSCSpecTypeResult.okType = SCSpecTypeDef.decode(stream);
        decodedSCSpecTypeResult.errorType = SCSpecTypeDef.decode(stream);
        return decodedSCSpecTypeResult;
    }

    public int hashCode() {
        return Objects.hash(this.okType, this.errorType);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SCSpecTypeResult)) {
            return false;
        }
        SCSpecTypeResult other = (SCSpecTypeResult)object;
        return Objects.equals(this.okType, other.okType) && Objects.equals(this.errorType, other.errorType);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SCSpecTypeResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCSpecTypeResult.fromXdrByteArray(bytes);
    }

    public static SCSpecTypeResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCSpecTypeResult.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private SCSpecTypeDef okType;
        private SCSpecTypeDef errorType;

        public Builder okType(SCSpecTypeDef okType) {
            this.okType = okType;
            return this;
        }

        public Builder errorType(SCSpecTypeDef errorType) {
            this.errorType = errorType;
            return this;
        }

        public SCSpecTypeResult build() {
            SCSpecTypeResult val = new SCSpecTypeResult();
            val.setOkType(this.okType);
            val.setErrorType(this.errorType);
            return val;
        }
    }
}

