/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCSpecUDTUnionCaseTupleV0;
import org.stellar.sdk.xdr.SCSpecUDTUnionCaseV0Kind;
import org.stellar.sdk.xdr.SCSpecUDTUnionCaseVoidV0;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCSpecUDTUnionCaseV0
implements XdrElement {
    SCSpecUDTUnionCaseV0Kind kind;
    private SCSpecUDTUnionCaseVoidV0 voidCase;
    private SCSpecUDTUnionCaseTupleV0 tupleCase;

    public SCSpecUDTUnionCaseV0Kind getDiscriminant() {
        return this.kind;
    }

    public void setDiscriminant(SCSpecUDTUnionCaseV0Kind value) {
        this.kind = value;
    }

    public SCSpecUDTUnionCaseVoidV0 getVoidCase() {
        return this.voidCase;
    }

    public void setVoidCase(SCSpecUDTUnionCaseVoidV0 value) {
        this.voidCase = value;
    }

    public SCSpecUDTUnionCaseTupleV0 getTupleCase() {
        return this.tupleCase;
    }

    public void setTupleCase(SCSpecUDTUnionCaseTupleV0 value) {
        this.tupleCase = value;
    }

    public static void encode(XdrDataOutputStream stream, SCSpecUDTUnionCaseV0 encodedSCSpecUDTUnionCaseV0) throws IOException {
        stream.writeInt(encodedSCSpecUDTUnionCaseV0.getDiscriminant().getValue());
        switch (encodedSCSpecUDTUnionCaseV0.getDiscriminant()) {
            case SC_SPEC_UDT_UNION_CASE_VOID_V0: {
                SCSpecUDTUnionCaseVoidV0.encode(stream, encodedSCSpecUDTUnionCaseV0.voidCase);
                break;
            }
            case SC_SPEC_UDT_UNION_CASE_TUPLE_V0: {
                SCSpecUDTUnionCaseTupleV0.encode(stream, encodedSCSpecUDTUnionCaseV0.tupleCase);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCSpecUDTUnionCaseV0.encode(stream, this);
    }

    public static SCSpecUDTUnionCaseV0 decode(XdrDataInputStream stream) throws IOException {
        SCSpecUDTUnionCaseV0 decodedSCSpecUDTUnionCaseV0 = new SCSpecUDTUnionCaseV0();
        SCSpecUDTUnionCaseV0Kind discriminant = SCSpecUDTUnionCaseV0Kind.decode(stream);
        decodedSCSpecUDTUnionCaseV0.setDiscriminant(discriminant);
        switch (decodedSCSpecUDTUnionCaseV0.getDiscriminant()) {
            case SC_SPEC_UDT_UNION_CASE_VOID_V0: {
                decodedSCSpecUDTUnionCaseV0.voidCase = SCSpecUDTUnionCaseVoidV0.decode(stream);
                break;
            }
            case SC_SPEC_UDT_UNION_CASE_TUPLE_V0: {
                decodedSCSpecUDTUnionCaseV0.tupleCase = SCSpecUDTUnionCaseTupleV0.decode(stream);
            }
        }
        return decodedSCSpecUDTUnionCaseV0;
    }

    public int hashCode() {
        return Objects.hash(this.voidCase, this.tupleCase, this.kind);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SCSpecUDTUnionCaseV0)) {
            return false;
        }
        SCSpecUDTUnionCaseV0 other = (SCSpecUDTUnionCaseV0)object;
        return Objects.equals(this.voidCase, other.voidCase) && Objects.equals(this.tupleCase, other.tupleCase) && Objects.equals(this.kind, other.kind);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SCSpecUDTUnionCaseV0 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCSpecUDTUnionCaseV0.fromXdrByteArray(bytes);
    }

    public static SCSpecUDTUnionCaseV0 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCSpecUDTUnionCaseV0.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private SCSpecUDTUnionCaseV0Kind discriminant;
        private SCSpecUDTUnionCaseVoidV0 voidCase;
        private SCSpecUDTUnionCaseTupleV0 tupleCase;

        public Builder discriminant(SCSpecUDTUnionCaseV0Kind discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        public Builder voidCase(SCSpecUDTUnionCaseVoidV0 voidCase) {
            this.voidCase = voidCase;
            return this;
        }

        public Builder tupleCase(SCSpecUDTUnionCaseTupleV0 tupleCase) {
            this.tupleCase = tupleCase;
            return this;
        }

        public SCSpecUDTUnionCaseV0 build() {
            SCSpecUDTUnionCaseV0 val = new SCSpecUDTUnionCaseV0();
            val.setDiscriminant(this.discriminant);
            val.setVoidCase(this.voidCase);
            val.setTupleCase(this.tupleCase);
            return val;
        }
    }
}

