/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SignerKey;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class Signer
implements XdrElement {
    private SignerKey key;
    private Uint32 weight;

    public SignerKey getKey() {
        return this.key;
    }

    public void setKey(SignerKey value) {
        this.key = value;
    }

    public Uint32 getWeight() {
        return this.weight;
    }

    public void setWeight(Uint32 value) {
        this.weight = value;
    }

    public static void encode(XdrDataOutputStream stream, Signer encodedSigner) throws IOException {
        SignerKey.encode(stream, encodedSigner.key);
        Uint32.encode(stream, encodedSigner.weight);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        Signer.encode(stream, this);
    }

    public static Signer decode(XdrDataInputStream stream) throws IOException {
        Signer decodedSigner = new Signer();
        decodedSigner.key = SignerKey.decode(stream);
        decodedSigner.weight = Uint32.decode(stream);
        return decodedSigner;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.weight);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Signer)) {
            return false;
        }
        Signer other = (Signer)object;
        return Objects.equals(this.key, other.key) && Objects.equals(this.weight, other.weight);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Signer fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Signer.fromXdrByteArray(bytes);
    }

    public static Signer fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Signer.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private SignerKey key;
        private Uint32 weight;

        public Builder key(SignerKey key) {
            this.key = key;
            return this;
        }

        public Builder weight(Uint32 weight) {
            this.weight = weight;
            return this;
        }

        public Signer build() {
            Signer val = new Signer();
            val.setKey(this.key);
            val.setWeight(this.weight);
            return val;
        }
    }
}

