/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SimplePaymentResult
implements XdrElement {
    private AccountID destination;
    private Asset asset;
    private Int64 amount;

    public AccountID getDestination() {
        return this.destination;
    }

    public void setDestination(AccountID value) {
        this.destination = value;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset value) {
        this.asset = value;
    }

    public Int64 getAmount() {
        return this.amount;
    }

    public void setAmount(Int64 value) {
        this.amount = value;
    }

    public static void encode(XdrDataOutputStream stream, SimplePaymentResult encodedSimplePaymentResult) throws IOException {
        AccountID.encode(stream, encodedSimplePaymentResult.destination);
        Asset.encode(stream, encodedSimplePaymentResult.asset);
        Int64.encode(stream, encodedSimplePaymentResult.amount);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SimplePaymentResult.encode(stream, this);
    }

    public static SimplePaymentResult decode(XdrDataInputStream stream) throws IOException {
        SimplePaymentResult decodedSimplePaymentResult = new SimplePaymentResult();
        decodedSimplePaymentResult.destination = AccountID.decode(stream);
        decodedSimplePaymentResult.asset = Asset.decode(stream);
        decodedSimplePaymentResult.amount = Int64.decode(stream);
        return decodedSimplePaymentResult;
    }

    public int hashCode() {
        return Objects.hash(this.destination, this.asset, this.amount);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SimplePaymentResult)) {
            return false;
        }
        SimplePaymentResult other = (SimplePaymentResult)object;
        return Objects.equals(this.destination, other.destination) && Objects.equals(this.asset, other.asset) && Objects.equals(this.amount, other.amount);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SimplePaymentResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SimplePaymentResult.fromXdrByteArray(bytes);
    }

    public static SimplePaymentResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SimplePaymentResult.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private AccountID destination;
        private Asset asset;
        private Int64 amount;

        public Builder destination(AccountID destination) {
            this.destination = destination;
            return this;
        }

        public Builder asset(Asset asset) {
            this.asset = asset;
            return this;
        }

        public Builder amount(Int64 amount) {
            this.amount = amount;
            return this;
        }

        public SimplePaymentResult build() {
            SimplePaymentResult val = new SimplePaymentResult();
            val.setDestination(this.destination);
            val.setAsset(this.asset);
            val.setAmount(this.amount);
            return val;
        }
    }
}

