/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ContractEvent;
import org.stellar.sdk.xdr.DiagnosticEvent;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.SorobanTransactionMetaExt;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SorobanTransactionMeta
implements XdrElement {
    private SorobanTransactionMetaExt ext;
    private ContractEvent[] events;
    private SCVal returnValue;
    private DiagnosticEvent[] diagnosticEvents;

    public SorobanTransactionMetaExt getExt() {
        return this.ext;
    }

    public void setExt(SorobanTransactionMetaExt value) {
        this.ext = value;
    }

    public ContractEvent[] getEvents() {
        return this.events;
    }

    public void setEvents(ContractEvent[] value) {
        this.events = value;
    }

    public SCVal getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(SCVal value) {
        this.returnValue = value;
    }

    public DiagnosticEvent[] getDiagnosticEvents() {
        return this.diagnosticEvents;
    }

    public void setDiagnosticEvents(DiagnosticEvent[] value) {
        this.diagnosticEvents = value;
    }

    public static void encode(XdrDataOutputStream stream, SorobanTransactionMeta encodedSorobanTransactionMeta) throws IOException {
        SorobanTransactionMetaExt.encode(stream, encodedSorobanTransactionMeta.ext);
        int eventssize = encodedSorobanTransactionMeta.getEvents().length;
        stream.writeInt(eventssize);
        for (int i = 0; i < eventssize; ++i) {
            ContractEvent.encode(stream, encodedSorobanTransactionMeta.events[i]);
        }
        SCVal.encode(stream, encodedSorobanTransactionMeta.returnValue);
        int diagnosticEventssize = encodedSorobanTransactionMeta.getDiagnosticEvents().length;
        stream.writeInt(diagnosticEventssize);
        for (int i = 0; i < diagnosticEventssize; ++i) {
            DiagnosticEvent.encode(stream, encodedSorobanTransactionMeta.diagnosticEvents[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SorobanTransactionMeta.encode(stream, this);
    }

    public static SorobanTransactionMeta decode(XdrDataInputStream stream) throws IOException {
        SorobanTransactionMeta decodedSorobanTransactionMeta = new SorobanTransactionMeta();
        decodedSorobanTransactionMeta.ext = SorobanTransactionMetaExt.decode(stream);
        int eventssize = stream.readInt();
        decodedSorobanTransactionMeta.events = new ContractEvent[eventssize];
        for (int i = 0; i < eventssize; ++i) {
            decodedSorobanTransactionMeta.events[i] = ContractEvent.decode(stream);
        }
        decodedSorobanTransactionMeta.returnValue = SCVal.decode(stream);
        int diagnosticEventssize = stream.readInt();
        decodedSorobanTransactionMeta.diagnosticEvents = new DiagnosticEvent[diagnosticEventssize];
        for (int i = 0; i < diagnosticEventssize; ++i) {
            decodedSorobanTransactionMeta.diagnosticEvents[i] = DiagnosticEvent.decode(stream);
        }
        return decodedSorobanTransactionMeta;
    }

    public int hashCode() {
        return Objects.hash(this.ext, Arrays.hashCode(this.events), this.returnValue, Arrays.hashCode(this.diagnosticEvents));
    }

    public boolean equals(Object object) {
        if (!(object instanceof SorobanTransactionMeta)) {
            return false;
        }
        SorobanTransactionMeta other = (SorobanTransactionMeta)object;
        return Objects.equals(this.ext, other.ext) && Arrays.equals(this.events, other.events) && Objects.equals(this.returnValue, other.returnValue) && Arrays.equals(this.diagnosticEvents, other.diagnosticEvents);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SorobanTransactionMeta fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SorobanTransactionMeta.fromXdrByteArray(bytes);
    }

    public static SorobanTransactionMeta fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SorobanTransactionMeta.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private SorobanTransactionMetaExt ext;
        private ContractEvent[] events;
        private SCVal returnValue;
        private DiagnosticEvent[] diagnosticEvents;

        public Builder ext(SorobanTransactionMetaExt ext) {
            this.ext = ext;
            return this;
        }

        public Builder events(ContractEvent[] events) {
            this.events = events;
            return this;
        }

        public Builder returnValue(SCVal returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        public Builder diagnosticEvents(DiagnosticEvent[] diagnosticEvents) {
            this.diagnosticEvents = diagnosticEvents;
            return this;
        }

        public SorobanTransactionMeta build() {
            SorobanTransactionMeta val = new SorobanTransactionMeta();
            val.setExt(this.ext);
            val.setEvents(this.events);
            val.setReturnValue(this.returnValue);
            val.setDiagnosticEvents(this.diagnosticEvents);
            return val;
        }
    }
}

