/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ExtensionPoint;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SorobanTransactionMetaExtV1
implements XdrElement {
    private ExtensionPoint ext;
    private Int64 totalNonRefundableResourceFeeCharged;
    private Int64 totalRefundableResourceFeeCharged;
    private Int64 rentFeeCharged;

    public ExtensionPoint getExt() {
        return this.ext;
    }

    public void setExt(ExtensionPoint value) {
        this.ext = value;
    }

    public Int64 getTotalNonRefundableResourceFeeCharged() {
        return this.totalNonRefundableResourceFeeCharged;
    }

    public void setTotalNonRefundableResourceFeeCharged(Int64 value) {
        this.totalNonRefundableResourceFeeCharged = value;
    }

    public Int64 getTotalRefundableResourceFeeCharged() {
        return this.totalRefundableResourceFeeCharged;
    }

    public void setTotalRefundableResourceFeeCharged(Int64 value) {
        this.totalRefundableResourceFeeCharged = value;
    }

    public Int64 getRentFeeCharged() {
        return this.rentFeeCharged;
    }

    public void setRentFeeCharged(Int64 value) {
        this.rentFeeCharged = value;
    }

    public static void encode(XdrDataOutputStream stream, SorobanTransactionMetaExtV1 encodedSorobanTransactionMetaExtV1) throws IOException {
        ExtensionPoint.encode(stream, encodedSorobanTransactionMetaExtV1.ext);
        Int64.encode(stream, encodedSorobanTransactionMetaExtV1.totalNonRefundableResourceFeeCharged);
        Int64.encode(stream, encodedSorobanTransactionMetaExtV1.totalRefundableResourceFeeCharged);
        Int64.encode(stream, encodedSorobanTransactionMetaExtV1.rentFeeCharged);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SorobanTransactionMetaExtV1.encode(stream, this);
    }

    public static SorobanTransactionMetaExtV1 decode(XdrDataInputStream stream) throws IOException {
        SorobanTransactionMetaExtV1 decodedSorobanTransactionMetaExtV1 = new SorobanTransactionMetaExtV1();
        decodedSorobanTransactionMetaExtV1.ext = ExtensionPoint.decode(stream);
        decodedSorobanTransactionMetaExtV1.totalNonRefundableResourceFeeCharged = Int64.decode(stream);
        decodedSorobanTransactionMetaExtV1.totalRefundableResourceFeeCharged = Int64.decode(stream);
        decodedSorobanTransactionMetaExtV1.rentFeeCharged = Int64.decode(stream);
        return decodedSorobanTransactionMetaExtV1;
    }

    public int hashCode() {
        return Objects.hash(this.ext, this.totalNonRefundableResourceFeeCharged, this.totalRefundableResourceFeeCharged, this.rentFeeCharged);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SorobanTransactionMetaExtV1)) {
            return false;
        }
        SorobanTransactionMetaExtV1 other = (SorobanTransactionMetaExtV1)object;
        return Objects.equals(this.ext, other.ext) && Objects.equals(this.totalNonRefundableResourceFeeCharged, other.totalNonRefundableResourceFeeCharged) && Objects.equals(this.totalRefundableResourceFeeCharged, other.totalRefundableResourceFeeCharged) && Objects.equals(this.rentFeeCharged, other.rentFeeCharged);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static SorobanTransactionMetaExtV1 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SorobanTransactionMetaExtV1.fromXdrByteArray(bytes);
    }

    public static SorobanTransactionMetaExtV1 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SorobanTransactionMetaExtV1.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private ExtensionPoint ext;
        private Int64 totalNonRefundableResourceFeeCharged;
        private Int64 totalRefundableResourceFeeCharged;
        private Int64 rentFeeCharged;

        public Builder ext(ExtensionPoint ext) {
            this.ext = ext;
            return this;
        }

        public Builder totalNonRefundableResourceFeeCharged(Int64 totalNonRefundableResourceFeeCharged) {
            this.totalNonRefundableResourceFeeCharged = totalNonRefundableResourceFeeCharged;
            return this;
        }

        public Builder totalRefundableResourceFeeCharged(Int64 totalRefundableResourceFeeCharged) {
            this.totalRefundableResourceFeeCharged = totalRefundableResourceFeeCharged;
            return this;
        }

        public Builder rentFeeCharged(Int64 rentFeeCharged) {
            this.rentFeeCharged = rentFeeCharged;
            return this;
        }

        public SorobanTransactionMetaExtV1 build() {
            SorobanTransactionMetaExtV1 val = new SorobanTransactionMetaExtV1();
            val.setExt(this.ext);
            val.setTotalNonRefundableResourceFeeCharged(this.totalNonRefundableResourceFeeCharged);
            val.setTotalRefundableResourceFeeCharged(this.totalRefundableResourceFeeCharged);
            val.setRentFeeCharged(this.rentFeeCharged);
            return val;
        }
    }
}

