/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TTLEntry
implements XdrElement {
    private Hash keyHash;
    private Uint32 liveUntilLedgerSeq;

    public Hash getKeyHash() {
        return this.keyHash;
    }

    public void setKeyHash(Hash value) {
        this.keyHash = value;
    }

    public Uint32 getLiveUntilLedgerSeq() {
        return this.liveUntilLedgerSeq;
    }

    public void setLiveUntilLedgerSeq(Uint32 value) {
        this.liveUntilLedgerSeq = value;
    }

    public static void encode(XdrDataOutputStream stream, TTLEntry encodedTTLEntry) throws IOException {
        Hash.encode(stream, encodedTTLEntry.keyHash);
        Uint32.encode(stream, encodedTTLEntry.liveUntilLedgerSeq);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TTLEntry.encode(stream, this);
    }

    public static TTLEntry decode(XdrDataInputStream stream) throws IOException {
        TTLEntry decodedTTLEntry = new TTLEntry();
        decodedTTLEntry.keyHash = Hash.decode(stream);
        decodedTTLEntry.liveUntilLedgerSeq = Uint32.decode(stream);
        return decodedTTLEntry;
    }

    public int hashCode() {
        return Objects.hash(this.keyHash, this.liveUntilLedgerSeq);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TTLEntry)) {
            return false;
        }
        TTLEntry other = (TTLEntry)object;
        return Objects.equals(this.keyHash, other.keyHash) && Objects.equals(this.liveUntilLedgerSeq, other.liveUntilLedgerSeq);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static TTLEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TTLEntry.fromXdrByteArray(bytes);
    }

    public static TTLEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TTLEntry.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private Hash keyHash;
        private Uint32 liveUntilLedgerSeq;

        public Builder keyHash(Hash keyHash) {
            this.keyHash = keyHash;
            return this;
        }

        public Builder liveUntilLedgerSeq(Uint32 liveUntilLedgerSeq) {
            this.liveUntilLedgerSeq = liveUntilLedgerSeq;
            return this;
        }

        public TTLEntry build() {
            TTLEntry val = new TTLEntry();
            val.setKeyHash(this.keyHash);
            val.setLiveUntilLedgerSeq(this.liveUntilLedgerSeq);
            return val;
        }
    }
}

