/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.TimePoint;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TimeBounds
implements XdrElement {
    private TimePoint minTime;
    private TimePoint maxTime;

    public TimePoint getMinTime() {
        return this.minTime;
    }

    public void setMinTime(TimePoint value) {
        this.minTime = value;
    }

    public TimePoint getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(TimePoint value) {
        this.maxTime = value;
    }

    public static void encode(XdrDataOutputStream stream, TimeBounds encodedTimeBounds) throws IOException {
        TimePoint.encode(stream, encodedTimeBounds.minTime);
        TimePoint.encode(stream, encodedTimeBounds.maxTime);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TimeBounds.encode(stream, this);
    }

    public static TimeBounds decode(XdrDataInputStream stream) throws IOException {
        TimeBounds decodedTimeBounds = new TimeBounds();
        decodedTimeBounds.minTime = TimePoint.decode(stream);
        decodedTimeBounds.maxTime = TimePoint.decode(stream);
        return decodedTimeBounds;
    }

    public int hashCode() {
        return Objects.hash(this.minTime, this.maxTime);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TimeBounds)) {
            return false;
        }
        TimeBounds other = (TimeBounds)object;
        return Objects.equals(this.minTime, other.minTime) && Objects.equals(this.maxTime, other.maxTime);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static TimeBounds fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TimeBounds.fromXdrByteArray(bytes);
    }

    public static TimeBounds fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TimeBounds.decode(xdrDataInputStream);
    }

    public static final class Builder {
        private TimePoint minTime;
        private TimePoint maxTime;

        public Builder minTime(TimePoint minTime) {
            this.minTime = minTime;
            return this;
        }

        public Builder maxTime(TimePoint maxTime) {
            this.maxTime = maxTime;
            return this;
        }

        public TimeBounds build() {
            TimeBounds val = new TimeBounds();
            val.setMinTime(this.minTime);
            val.setMaxTime(this.maxTime);
            return val;
        }
    }
}

