/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Memo;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.Preconditions;
import org.stellar.sdk.xdr.SequenceNumber;
import org.stellar.sdk.xdr.SorobanTransactionData;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class Transaction
implements XdrElement {
    private MuxedAccount sourceAccount;
    private Uint32 fee;
    private SequenceNumber seqNum;
    private Preconditions cond;
    private Memo memo;
    private Operation[] operations;
    private TransactionExt ext;

    public MuxedAccount getSourceAccount() {
        return this.sourceAccount;
    }

    public void setSourceAccount(MuxedAccount value) {
        this.sourceAccount = value;
    }

    public Uint32 getFee() {
        return this.fee;
    }

    public void setFee(Uint32 value) {
        this.fee = value;
    }

    public SequenceNumber getSeqNum() {
        return this.seqNum;
    }

    public void setSeqNum(SequenceNumber value) {
        this.seqNum = value;
    }

    public Preconditions getCond() {
        return this.cond;
    }

    public void setCond(Preconditions value) {
        this.cond = value;
    }

    public Memo getMemo() {
        return this.memo;
    }

    public void setMemo(Memo value) {
        this.memo = value;
    }

    public Operation[] getOperations() {
        return this.operations;
    }

    public void setOperations(Operation[] value) {
        this.operations = value;
    }

    public TransactionExt getExt() {
        return this.ext;
    }

    public void setExt(TransactionExt value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, Transaction encodedTransaction) throws IOException {
        MuxedAccount.encode(stream, encodedTransaction.sourceAccount);
        Uint32.encode(stream, encodedTransaction.fee);
        SequenceNumber.encode(stream, encodedTransaction.seqNum);
        Preconditions.encode(stream, encodedTransaction.cond);
        Memo.encode(stream, encodedTransaction.memo);
        int operationssize = encodedTransaction.getOperations().length;
        stream.writeInt(operationssize);
        for (int i = 0; i < operationssize; ++i) {
            Operation.encode(stream, encodedTransaction.operations[i]);
        }
        TransactionExt.encode(stream, encodedTransaction.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        Transaction.encode(stream, this);
    }

    public static Transaction decode(XdrDataInputStream stream) throws IOException {
        Transaction decodedTransaction = new Transaction();
        decodedTransaction.sourceAccount = MuxedAccount.decode(stream);
        decodedTransaction.fee = Uint32.decode(stream);
        decodedTransaction.seqNum = SequenceNumber.decode(stream);
        decodedTransaction.cond = Preconditions.decode(stream);
        decodedTransaction.memo = Memo.decode(stream);
        int operationssize = stream.readInt();
        decodedTransaction.operations = new Operation[operationssize];
        for (int i = 0; i < operationssize; ++i) {
            decodedTransaction.operations[i] = Operation.decode(stream);
        }
        decodedTransaction.ext = TransactionExt.decode(stream);
        return decodedTransaction;
    }

    public int hashCode() {
        return Objects.hash(this.sourceAccount, this.fee, this.seqNum, this.cond, this.memo, Arrays.hashCode(this.operations), this.ext);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)object;
        return Objects.equals(this.sourceAccount, other.sourceAccount) && Objects.equals(this.fee, other.fee) && Objects.equals(this.seqNum, other.seqNum) && Objects.equals(this.cond, other.cond) && Objects.equals(this.memo, other.memo) && Arrays.equals(this.operations, other.operations) && Objects.equals(this.ext, other.ext);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static Transaction fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Transaction.fromXdrByteArray(bytes);
    }

    public static Transaction fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Transaction.decode(xdrDataInputStream);
    }

    public static class TransactionExt
    implements XdrElement {
        Integer v;
        private SorobanTransactionData sorobanData;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public SorobanTransactionData getSorobanData() {
            return this.sorobanData;
        }

        public void setSorobanData(SorobanTransactionData value) {
            this.sorobanData = value;
        }

        public static void encode(XdrDataOutputStream stream, TransactionExt encodedTransactionExt) throws IOException {
            stream.writeInt(encodedTransactionExt.getDiscriminant());
            switch (encodedTransactionExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    SorobanTransactionData.encode(stream, encodedTransactionExt.sorobanData);
                }
            }
        }

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            TransactionExt.encode(stream, this);
        }

        public static TransactionExt decode(XdrDataInputStream stream) throws IOException {
            TransactionExt decodedTransactionExt = new TransactionExt();
            Integer discriminant = stream.readInt();
            decodedTransactionExt.setDiscriminant(discriminant);
            switch (decodedTransactionExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    decodedTransactionExt.sorobanData = SorobanTransactionData.decode(stream);
                }
            }
            return decodedTransactionExt;
        }

        public int hashCode() {
            return Objects.hash(this.sorobanData, this.v);
        }

        public boolean equals(Object object) {
            if (!(object instanceof TransactionExt)) {
                return false;
            }
            TransactionExt other = (TransactionExt)object;
            return Objects.equals(this.sorobanData, other.sorobanData) && Objects.equals(this.v, other.v);
        }

        @Override
        public String toXdrBase64() throws IOException {
            return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
        }

        @Override
        public byte[] toXdrByteArray() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
            this.encode(xdrDataOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        public static TransactionExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return TransactionExt.fromXdrByteArray(bytes);
        }

        public static TransactionExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return TransactionExt.decode(xdrDataInputStream);
        }

        public static final class Builder {
            private Integer discriminant;
            private SorobanTransactionData sorobanData;

            public Builder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            public Builder sorobanData(SorobanTransactionData sorobanData) {
                this.sorobanData = sorobanData;
                return this;
            }

            public TransactionExt build() {
                TransactionExt val = new TransactionExt();
                val.setDiscriminant(this.discriminant);
                val.setSorobanData(this.sorobanData);
                return val;
            }
        }
    }

    public static final class Builder {
        private MuxedAccount sourceAccount;
        private Uint32 fee;
        private SequenceNumber seqNum;
        private Preconditions cond;
        private Memo memo;
        private Operation[] operations;
        private TransactionExt ext;

        public Builder sourceAccount(MuxedAccount sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this;
        }

        public Builder fee(Uint32 fee) {
            this.fee = fee;
            return this;
        }

        public Builder seqNum(SequenceNumber seqNum) {
            this.seqNum = seqNum;
            return this;
        }

        public Builder cond(Preconditions cond) {
            this.cond = cond;
            return this;
        }

        public Builder memo(Memo memo) {
            this.memo = memo;
            return this;
        }

        public Builder operations(Operation[] operations) {
            this.operations = operations;
            return this;
        }

        public Builder ext(TransactionExt ext) {
            this.ext = ext;
            return this;
        }

        public Transaction build() {
            Transaction val = new Transaction();
            val.setSourceAccount(this.sourceAccount);
            val.setFee(this.fee);
            val.setSeqNum(this.seqNum);
            val.setCond(this.cond);
            val.setMemo(this.memo);
            val.setOperations(this.operations);
            val.setExt(this.ext);
            return val;
        }
    }
}

