/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum TrustLineFlags implements XdrElement
{
    AUTHORIZED_FLAG(1),
    AUTHORIZED_TO_MAINTAIN_LIABILITIES_FLAG(2),
    TRUSTLINE_CLAWBACK_ENABLED_FLAG(4);

    private int mValue;

    private TrustLineFlags(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static TrustLineFlags decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 1: {
                return AUTHORIZED_FLAG;
            }
            case 2: {
                return AUTHORIZED_TO_MAINTAIN_LIABILITIES_FLAG;
            }
            case 4: {
                return TRUSTLINE_CLAWBACK_ENABLED_FLAG;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, TrustLineFlags value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TrustLineFlags.encode(stream, this);
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static TrustLineFlags fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TrustLineFlags.fromXdrByteArray(bytes);
    }

    public static TrustLineFlags fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TrustLineFlags.decode(xdrDataInputStream);
    }
}

