/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class XdrUnsignedInteger
implements XdrElement {
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    public static final long MIN_VALUE = 0L;
    private final Long number;

    public XdrUnsignedInteger(Long number) {
        if (number < 0L || number > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("number must be between 0 and 2^32 - 1 inclusive");
        }
        this.number = number;
    }

    public XdrUnsignedInteger(Integer number) {
        if (number < 0) {
            throw new IllegalArgumentException("number must be greater than or equal to 0 if you want to construct it from Integer");
        }
        this.number = number.longValue();
    }

    public Long getNumber() {
        return this.number;
    }

    public static XdrUnsignedInteger decode(XdrDataInputStream stream) throws IOException {
        int intValue = stream.readInt();
        long uint32Value = Integer.toUnsignedLong(intValue);
        return new XdrUnsignedInteger(uint32Value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.number.intValue());
    }

    @Override
    public String toXdrBase64() throws IOException {
        return Base64Factory.getInstance().encodeToString(this.toXdrByteArray());
    }

    @Override
    public byte[] toXdrByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdrDataOutputStream xdrDataOutputStream = new XdrDataOutputStream(byteArrayOutputStream);
        this.encode(xdrDataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static XdrUnsignedInteger fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return XdrUnsignedInteger.fromXdrByteArray(bytes);
    }

    public static XdrUnsignedInteger fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return XdrUnsignedInteger.decode(xdrDataInputStream);
    }

    public int hashCode() {
        return Objects.hash(this.number);
    }

    public boolean equals(Object object) {
        if (!(object instanceof XdrUnsignedInteger)) {
            return false;
        }
        XdrUnsignedInteger other = (XdrUnsignedInteger)object;
        return Objects.equals(this.number, other.number);
    }

    public String toString() {
        return "XdrUnsignedInteger(number=" + this.getNumber() + ")";
    }
}

