/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.certvalidator.structure;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import network.oxalis.commons.certvalidator.api.CertificateValidationException;
import network.oxalis.commons.certvalidator.api.FailedValidationException;
import network.oxalis.commons.certvalidator.api.Report;
import network.oxalis.commons.certvalidator.api.ValidatorRule;
import network.oxalis.commons.certvalidator.structure.AbstractJunction;

public class OrJunction
extends AbstractJunction {
    public OrJunction(ValidatorRule ... validatorRules) {
        super(validatorRules);
    }

    public OrJunction(List<ValidatorRule> validatorRules) {
        super(validatorRules);
    }

    @Override
    public Report validate(X509Certificate certificate, Report report) throws CertificateValidationException {
        ArrayList<CertificateValidationException> exceptions = new ArrayList<CertificateValidationException>();
        for (ValidatorRule validatorRule : this.validatorRules) {
            try {
                return validatorRule.validate(certificate, report.copy());
            }
            catch (CertificateValidationException certificateValidationException) {
                exceptions.add(certificateValidationException);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Or-junction failed with results:");
        for (Exception exception : exceptions) {
            stringBuilder.append("\n* ").append(exception.getMessage());
        }
        throw new FailedValidationException(stringBuilder.toString());
    }
}

