/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.pkix.ocsp;

import java.math.BigInteger;
import java.net.URI;
import java.security.cert.X509Certificate;
import network.oxalis.pkix.ocsp.AbstractOcspClient;
import network.oxalis.pkix.ocsp.CertificateIssuer;
import network.oxalis.pkix.ocsp.CertificateResult;
import network.oxalis.pkix.ocsp.CertificateStatus;
import network.oxalis.pkix.ocsp.OcspException;
import network.oxalis.pkix.ocsp.OcspRequest;
import network.oxalis.pkix.ocsp.OcspResponse;
import network.oxalis.pkix.ocsp.builder.BuildHandler;
import network.oxalis.pkix.ocsp.builder.Builder;
import network.oxalis.pkix.ocsp.builder.Properties;
import network.oxalis.pkix.ocsp.builder.Property;

public class OcspClient
extends AbstractOcspClient {
    public static final Property<Boolean> EXCEPTION_ON_REVOKED = Property.create(true);
    public static final Property<Boolean> EXCEPTION_ON_UNKNOWN = Property.create(true);

    public static Builder<OcspClient> builder() {
        return new Builder<OcspClient>(new BuildHandler<OcspClient>(){

            @Override
            public OcspClient build(Properties properties) {
                return new OcspClient(properties);
            }
        });
    }

    private OcspClient(Properties properties) {
        super(properties);
    }

    public CertificateResult verify(X509Certificate certificate) throws OcspException {
        return this.verify(certificate, this.findIntermediate(certificate));
    }

    public CertificateResult verify(X509Certificate certificate, X509Certificate issuer) throws OcspException {
        return this.verify(CertificateIssuer.generate(issuer), certificate);
    }

    public CertificateResult verify(CertificateIssuer issuer, X509Certificate certificate) throws OcspException {
        URI uri = (URI)this.properties.get(OVERRIDE_URL);
        if (uri == null && (uri = this.detectOcspUri(certificate)) == null) {
            return new CertificateResult(CertificateStatus.UNKNOWN);
        }
        return this.verify(uri, issuer, certificate.getSerialNumber());
    }

    public CertificateResult verify(URI uri, CertificateIssuer issuer, BigInteger serialNumber) throws OcspException {
        OcspRequest request = new OcspRequest();
        request.setIssuer(issuer);
        request.addCertificates(serialNumber);
        if (((Boolean)this.properties.get(NONCE)).booleanValue()) {
            request.addNonce();
        }
        OcspResponse response = this.fetch(request, uri);
        response.verifyResponse();
        CertificateResult certificateResult = response.getResult().get(serialNumber);
        switch (certificateResult.getStatus()) {
            case REVOKED: {
                OcspException.trigger(this.properties.get(EXCEPTION_ON_REVOKED), "Certificate is revoked.", new Object[0]);
                break;
            }
            case UNKNOWN: {
                OcspException.trigger(this.properties.get(EXCEPTION_ON_UNKNOWN), "Status of certificate is unknown.", new Object[0]);
            }
        }
        return certificateResult;
    }
}

