/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.pkix.ocsp.fetcher;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import network.oxalis.pkix.ocsp.api.OcspFetcher;
import network.oxalis.pkix.ocsp.api.OcspFetcherResponse;
import network.oxalis.pkix.ocsp.builder.BuildHandler;
import network.oxalis.pkix.ocsp.builder.Builder;
import network.oxalis.pkix.ocsp.builder.Properties;
import network.oxalis.pkix.ocsp.builder.Property;
import network.oxalis.pkix.ocsp.fetcher.AbstractOcspFetcher;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class ApacheOcspFetcher
extends AbstractOcspFetcher {
    public static final Property<HttpClientConnectionManager> CONNECTION_MANAGER = Property.create();
    public static final Property<Boolean> CONNECTION_MANAGER_SHARED = Property.create(false);
    public static final Property<Integer> TIMEOUT_CONNECTION_MANAGER = Property.create(-1);

    public static Builder<OcspFetcher> builder() {
        return new Builder<OcspFetcher>(new BuildHandler<OcspFetcher>(){

            @Override
            public OcspFetcher build(Properties properties) {
                return new ApacheOcspFetcher(properties);
            }
        });
    }

    private ApacheOcspFetcher(Properties properties) {
        super(properties);
    }

    @Override
    public OcspFetcherResponse fetch(URI uri, byte[] content) throws IOException {
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeader("Content-Type", "application/ocsp-request");
        httpPost.setHeader("Accept", "application/ocsp-response");
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(content));
        httpPost.setConfig(this.getRequestConfig());
        return new ApacheOcspFetcherResponse(this.getHttpClient().execute((HttpUriRequest)httpPost));
    }

    protected CloseableHttpClient getHttpClient() {
        return HttpClientBuilder.create().setConnectionManager(this.properties.get(CONNECTION_MANAGER)).setConnectionManagerShared(this.properties.get(CONNECTION_MANAGER_SHARED).booleanValue()).build();
    }

    protected RequestConfig getRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(((Integer)this.properties.get(TIMEOUT_CONNECT)).intValue()).setSocketTimeout(((Integer)this.properties.get(TIMEOUT_READ)).intValue()).setConnectionRequestTimeout(this.properties.get(TIMEOUT_CONNECTION_MANAGER).intValue()).build();
    }

    private class ApacheOcspFetcherResponse
    implements OcspFetcherResponse {
        private CloseableHttpResponse response;

        public ApacheOcspFetcherResponse(CloseableHttpResponse response) {
            this.response = response;
        }

        @Override
        public int getStatus() {
            return this.response.getStatusLine().getStatusCode();
        }

        @Override
        public String getContentType() {
            return this.response.getFirstHeader("Content-Type").getValue();
        }

        @Override
        public InputStream getContent() throws IOException {
            return this.response.getEntity().getContent();
        }

        @Override
        public void close() throws IOException {
            this.response.close();
            this.response = null;
        }
    }
}

