/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.common.model;

import java.io.Serializable;
import network.oxalis.vefa.peppol.common.lang.PeppolParsingException;
import network.oxalis.vefa.peppol.common.model.AbstractQualifiedIdentifier;
import network.oxalis.vefa.peppol.common.model.Scheme;

public class DocumentTypeIdentifier
extends AbstractQualifiedIdentifier
implements Serializable {
    private static final long serialVersionUID = -3748163459655880167L;
    public static final String IDENTIFIER_SEPARATOR = "::";
    public static final String SYNTAX_SUBTYPE_SEPARATOR = "##";
    public static final String DOCUMENT_TYPE_SCHEME_BUSDOX_DOCID_QNS = "busdox-docid-qns";
    public static final String DOCUMENT_TYPE_SCHEME_PEPPOL_DOCTYPE_WILDCARD = "peppol-doctype-wildcard";
    @Deprecated
    public static final Scheme DEFAULT_SCHEME = Scheme.of("busdox-docid-qns");
    public static final Scheme BUSDOX_DOCID_QNS_SCHEME = Scheme.of("busdox-docid-qns");
    public static final Scheme PEPPOL_DOCTYPE_WILDCARD_SCHEME = Scheme.of("peppol-doctype-wildcard");

    public String getDefaultDocumentTypeIdentifierScheme() {
        return DOCUMENT_TYPE_SCHEME_BUSDOX_DOCID_QNS;
    }

    public static DocumentTypeIdentifier of(String identifier) {
        return new DocumentTypeIdentifier(identifier, DEFAULT_SCHEME);
    }

    public static DocumentTypeIdentifier of(String identifier, Scheme scheme) {
        return new DocumentTypeIdentifier(identifier, scheme);
    }

    public static DocumentTypeIdentifier parse(String str) throws PeppolParsingException {
        String[] parts = str.split(IDENTIFIER_SEPARATOR, 2);
        if (parts.length != 2) {
            throw new PeppolParsingException(String.format("Unable to parse document type identifier '%s'.", str));
        }
        return DocumentTypeIdentifier.of(parts[1], Scheme.of(parts[0]));
    }

    protected DocumentTypeIdentifier(String value, Scheme scheme) {
        super(value, scheme);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentTypeIdentifier that = (DocumentTypeIdentifier)o;
        return this.toString().equals(that.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return String.format("%s::%s", this.scheme, this.identifier);
    }
}

