/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import network.oxalis.vefa.peppol.common.api.SimpleEndpoint;
import network.oxalis.vefa.peppol.common.lang.EndpointNotFoundException;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;
import network.oxalis.vefa.peppol.common.model.TransportProfile;

public class ProcessMetadata<T extends SimpleEndpoint>
implements Serializable {
    private static final long serialVersionUID = -8684282659539348955L;
    private final List<ProcessIdentifier> processIdentifier;
    private final Map<TransportProfile, T> endpoints = new HashMap<TransportProfile, T>();

    public static <T extends SimpleEndpoint> ProcessMetadata<T> of(ProcessIdentifier processIdentifier, T ... endpoints) {
        return ProcessMetadata.of(Collections.singletonList(processIdentifier), Arrays.asList(endpoints));
    }

    public static <T extends SimpleEndpoint> ProcessMetadata<T> of(List<ProcessIdentifier> processIdentifier, T ... endpoints) {
        return ProcessMetadata.of(processIdentifier, Arrays.asList(endpoints));
    }

    public static <T extends SimpleEndpoint> ProcessMetadata<T> of(ProcessIdentifier processIdentifier, List<T> endpoints) {
        return new ProcessMetadata<T>(Collections.singletonList(processIdentifier), endpoints);
    }

    public static <T extends SimpleEndpoint> ProcessMetadata<T> of(List<ProcessIdentifier> processIdentifier, List<T> endpoints) {
        return new ProcessMetadata<T>(processIdentifier, endpoints);
    }

    private ProcessMetadata(List<ProcessIdentifier> processIdentifiers, List<T> endpoints) {
        this.processIdentifier = processIdentifiers;
        for (SimpleEndpoint endpoint : endpoints) {
            this.endpoints.put(endpoint.getTransportProfile(), endpoint);
        }
    }

    public List<ProcessIdentifier> getProcessIdentifier() {
        return this.processIdentifier;
    }

    public List<TransportProfile> getTransportProfiles() {
        return new ArrayList<TransportProfile>(this.endpoints.keySet());
    }

    public List<T> getEndpoints() {
        return new ArrayList<T>(this.endpoints.values());
    }

    public T getEndpoint(TransportProfile ... transportProfiles) throws EndpointNotFoundException {
        for (TransportProfile transportProfile : transportProfiles) {
            SimpleEndpoint endpoint;
            if (!this.endpoints.containsKey(transportProfile) || (endpoint = (SimpleEndpoint)this.endpoints.get(transportProfile)).getPeriod() != null && !endpoint.getPeriod().isCurrent()) continue;
            return (T)((SimpleEndpoint)this.endpoints.get(transportProfile));
        }
        throw new EndpointNotFoundException("Unable to find active endpoint information for given transport profile(s).");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessMetadata that = (ProcessMetadata)o;
        if (!this.processIdentifier.equals(that.processIdentifier)) {
            return false;
        }
        return this.endpoints.equals(that.endpoints);
    }

    public int hashCode() {
        int result = this.processIdentifier.hashCode();
        result = 31 * result + this.endpoints.hashCode();
        return result;
    }

    public String toString() {
        return "ProcessMetadata{processIdentifier=" + this.processIdentifier + ", endpoints=" + this.endpoints + "}";
    }
}

