/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.evidence.rem;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import network.oxalis.vefa.peppol.common.lang.PeppolRuntimeException;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.model.Scheme;
import network.oxalis.vefa.peppol.common.util.ExceptionUtil;
import network.oxalis.vefa.peppol.evidence.jaxb.receipt.PeppolRemExtension;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.AttributedElectronicAddressType;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.EventReasonType;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.ObjectFactory;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.REMEvidenceType;
import network.oxalis.vefa.peppol.evidence.lang.RemEvidenceException;
import network.oxalis.vefa.peppol.evidence.rem.EventReason;
import network.oxalis.vefa.peppol.security.xmldsig.DomUtils;

class RemHelper {
    private static JAXBContext jaxbContext;
    public static final ObjectFactory OBJECT_FACTORY;
    private static DatatypeFactory datatypeFactory;

    RemHelper() {
    }

    public static AttributedElectronicAddressType createElectronicAddressType(ParticipantIdentifier participant) {
        AttributedElectronicAddressType o = new AttributedElectronicAddressType();
        o.setValue(participant.getIdentifier());
        o.setScheme(participant.getScheme().getIdentifier());
        return o;
    }

    public static ParticipantIdentifier readElectronicAddressType(AttributedElectronicAddressType o) {
        return ParticipantIdentifier.of((String)o.getValue(), (Scheme)Scheme.of((String)o.getScheme()));
    }

    public static EventReasonType createEventReasonType(EventReason eventReason) {
        EventReasonType o = new EventReasonType();
        o.setCode(eventReason.getCode());
        o.setDetails(eventReason.getDetails());
        return o;
    }

    public static XMLGregorianCalendar toXmlGregorianCalendar(Date date) throws RemEvidenceException {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        XMLGregorianCalendar xmlGregorianCalendar = datatypeFactory.newXMLGregorianCalendar(c);
        xmlGregorianCalendar.setMillisecond(Integer.MIN_VALUE);
        return xmlGregorianCalendar;
    }

    public static Date fromXmlGregorianCalendar(XMLGregorianCalendar calendar) {
        return calendar.toGregorianCalendar().getTime();
    }

    public static Marshaller getMarshaller() throws JAXBException {
        return jaxbContext.createMarshaller();
    }

    public static Unmarshaller getUnmarshaller() throws JAXBException {
        return jaxbContext.createUnmarshaller();
    }

    public static DocumentBuilder getDocumentBuilder() throws RemEvidenceException {
        return (DocumentBuilder)ExceptionUtil.perform(RemEvidenceException.class, () -> DomUtils.newDocumentBuilder());
    }

    static {
        OBJECT_FACTORY = new ObjectFactory();
        ExceptionUtil.perform(PeppolRuntimeException.class, () -> {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{REMEvidenceType.class, PeppolRemExtension.class});
            datatypeFactory = DatatypeFactory.newInstance();
        });
    }
}

