/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.evidence.rem;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import network.oxalis.vefa.peppol.common.model.Signed;
import network.oxalis.vefa.peppol.evidence.lang.RemEvidenceException;
import network.oxalis.vefa.peppol.evidence.rem.Evidence;
import network.oxalis.vefa.peppol.evidence.rem.EvidenceReader;
import network.oxalis.vefa.peppol.evidence.rem.RemHelper;
import network.oxalis.vefa.peppol.security.lang.PeppolSecurityException;
import network.oxalis.vefa.peppol.security.xmldsig.XmldsigVerifier;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SignedEvidenceReader {
    public static Signed<Evidence> read(InputStream inputStream) throws RemEvidenceException, PeppolSecurityException {
        try {
            return SignedEvidenceReader.read(RemHelper.getDocumentBuilder().parse(inputStream));
        }
        catch (IOException | SAXException e) {
            throw new RemEvidenceException(e.getMessage(), e);
        }
    }

    public static Signed<Evidence> read(Node node) throws RemEvidenceException, PeppolSecurityException {
        if (!(node instanceof Document)) {
            throw new RemEvidenceException("Node of type Document required.");
        }
        X509Certificate certificate = XmldsigVerifier.verify((Document)((Document)node));
        return Signed.of((Object)EvidenceReader.read(node), (X509Certificate)certificate);
    }
}

