/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup.locator;

import java.net.URI;
import java.net.UnknownHostException;
import java.time.Duration;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.lookup.api.LookupException;
import network.oxalis.vefa.peppol.lookup.api.NotFoundException;
import network.oxalis.vefa.peppol.lookup.locator.AbstractLocator;
import network.oxalis.vefa.peppol.lookup.util.DynamicHostnameGenerator;
import network.oxalis.vefa.peppol.mode.Mode;
import org.apache.commons.lang3.StringUtils;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TextParseException;

public class BusdoxLocator
extends AbstractLocator {
    private long timeout = 30L;
    private int maxRetries = 3;
    private DynamicHostnameGenerator hostnameGenerator;

    public BusdoxLocator(Mode mode) {
        this(mode.getString("lookup.locator.busdox.prefix"), mode.getString("lookup.locator.hostname"), mode.getString("lookup.locator.busdox.algorithm"));
        this.maxRetries = Integer.parseInt(mode.getString("lookup.locator.busdox.maxRetries"));
        this.timeout = Long.parseLong(mode.getString("lookup.locator.busdox.timeout"));
    }

    public BusdoxLocator(String hostname) {
        this("B-", hostname, "MD5");
    }

    public BusdoxLocator(String prefix, String hostname, String algorithm) {
        this.hostnameGenerator = new DynamicHostnameGenerator(prefix, hostname, algorithm);
    }

    @Override
    public URI lookup(ParticipantIdentifier participantIdentifier) throws LookupException {
        String hostname = this.hostnameGenerator.generate(participantIdentifier);
        try {
            Lookup lookup = new Lookup(hostname);
            ExtendedResolver extendedResolver = new ExtendedResolver();
            try {
                if (StringUtils.isNotBlank((CharSequence)hostname)) {
                    extendedResolver.addResolver((Resolver)new SimpleResolver(hostname));
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            extendedResolver.addResolver(Lookup.getDefaultResolver());
            extendedResolver.setRetries(this.maxRetries);
            extendedResolver.setTimeout(Duration.ofSeconds(this.timeout));
            lookup.setResolver((Resolver)extendedResolver);
            int retryCountLeft = this.maxRetries;
            do {
                lookup.run();
            } while (lookup.getResult() == 2 && --retryCountLeft >= 0);
            if (lookup.getResult() == 2) {
                extendedResolver.setTCP(true);
                retryCountLeft = this.maxRetries;
                do {
                    lookup.run();
                } while (lookup.getResult() == 2 && --retryCountLeft >= 0);
            }
            if (lookup.getResult() != 0) {
                if (lookup.getResult() == 3 || lookup.getResult() == 2 || lookup.getResult() == 4) {
                    throw new NotFoundException(String.format("Identifier '%s' is not registered in SML.", participantIdentifier.getIdentifier()));
                }
                throw new LookupException(String.format("Error when looking up identifier '%s' in SML.", participantIdentifier.getIdentifier()));
            }
        }
        catch (TextParseException e) {
            throw new LookupException(e.getMessage(), e);
        }
        return URI.create(String.format("http://%s", hostname));
    }
}

