/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup.provider;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.util.ModelUtils;
import network.oxalis.vefa.peppol.lookup.api.MetadataProvider;

public class DefaultProvider
implements MetadataProvider {
    public static final int SEPARATOR_LENGTH = 2;
    public static final String WILDCARD_INDICATOR_CHARACTER = "*";
    public static final String NARROWER_SCHEMEPART_INDICATOR_CHARACTER = "@";

    @Override
    public List<URI> resolveDocumentIdentifiers(URI location, ParticipantIdentifier participant) {
        ArrayList<URI> resolvedDocumentIdentifiersURIList = new ArrayList<URI>();
        resolvedDocumentIdentifiersURIList.add(location.resolve(String.format("/%s", participant.urlencoded())));
        return resolvedDocumentIdentifiersURIList;
    }

    @Override
    public List<URI> resolveServiceMetadata(URI location, ParticipantIdentifier participantIdentifier, DocumentTypeIdentifier documentTypeIdentifier) {
        ArrayList<URI> resolvedServiceMetaDataURIList = new ArrayList<URI>();
        String documentTypeSchemeIdentifier = documentTypeIdentifier.getScheme().getIdentifier();
        if (documentTypeSchemeIdentifier.equals("peppol-doctype-wildcard")) {
            String instanceIdentifier = documentTypeIdentifier.getIdentifier();
            int customizationValueStartIndex = instanceIdentifier.indexOf("##") + 2;
            int customizationValueEndIndex = instanceIdentifier.lastIndexOf("::");
            String syntaxSpecificId = instanceIdentifier.substring(0, customizationValueStartIndex - 2);
            String customizationIdentifier = instanceIdentifier.substring(customizationValueStartIndex, customizationValueEndIndex);
            String version = instanceIdentifier.substring(customizationValueEndIndex + 2);
            String customizationIdentifierWithWildCardCharacter = customizationIdentifier + WILDCARD_INDICATOR_CHARACTER;
            String resolvedPeppolWildCardDocTypeDocumentIdentifierUrlEncoded = ModelUtils.urlencode((String)"%s::%s##%s::%s", (String[])new String[]{documentTypeSchemeIdentifier, syntaxSpecificId, customizationIdentifierWithWildCardCharacter, version});
            resolvedServiceMetaDataURIList.add(location.resolve(String.format("/%s/services/%s", participantIdentifier.urlencoded(), resolvedPeppolWildCardDocTypeDocumentIdentifierUrlEncoded)));
            while (customizationIdentifier.contains(NARROWER_SCHEMEPART_INDICATOR_CHARACTER)) {
                String trimmedCustomizationIdentifier = customizationIdentifier.substring(0, customizationIdentifier.lastIndexOf(NARROWER_SCHEMEPART_INDICATOR_CHARACTER));
                String trimmedCustomizationIdentifierWithWildCardCharacter = trimmedCustomizationIdentifier + WILDCARD_INDICATOR_CHARACTER;
                String trimmedResolvedDocumentIdentifierUrlEncoded = ModelUtils.urlencode((String)"%s::%s##%s::%s", (String[])new String[]{documentTypeSchemeIdentifier, syntaxSpecificId, trimmedCustomizationIdentifierWithWildCardCharacter, version});
                resolvedServiceMetaDataURIList.add(location.resolve(String.format("/%s/services/%s", participantIdentifier.urlencoded(), trimmedResolvedDocumentIdentifierUrlEncoded)));
                customizationIdentifier = trimmedCustomizationIdentifier;
            }
        }
        resolvedServiceMetaDataURIList.add(location.resolve(String.format("/%s/services/%s", participantIdentifier.urlencoded(), documentTypeIdentifier.urlencoded())));
        return resolvedServiceMetaDataURIList;
    }
}

