/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup.util;

import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XmlUtils {
    private static final Pattern ROOT_TAG_PATTERN = Pattern.compile("<(\\w*:{0,1}[^<?|^<!]*)>", 8);
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile("xmlns:{0,1}([A-Za-z0-9]*)\\w*=\\w*\"(.+?)\"", 8);
    private static XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newFactory();

    public static String extractRootNamespace(String xmlContent) {
        Matcher matcher = ROOT_TAG_PATTERN.matcher(xmlContent);
        if (matcher.find()) {
            String rootElement = matcher.group(1).trim();
            String rootNs = rootElement.split(" ", 2)[0].contains(":") ? rootElement.substring(0, rootElement.indexOf(":")) : "";
            Matcher nsMatcher = NAMESPACE_PATTERN.matcher(rootElement);
            while (nsMatcher.find()) {
                if (!nsMatcher.group(1).equals(rootNs)) continue;
                return nsMatcher.group(2);
            }
        }
        return null;
    }

    public static XMLStreamReader streamReader(InputStream inputStream) throws XMLStreamException {
        return XML_INPUT_FACTORY.createXMLStreamReader(inputStream);
    }

    XmlUtils() {
    }

    static {
        XML_INPUT_FACTORY.setProperty("javax.xml.stream.supportDTD", false);
        XML_INPUT_FACTORY.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
    }
}

