/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.sbdh.util;

import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import network.oxalis.vefa.peppol.sbdh.Ns;

public class XMLBinaryOutputStream
extends OutputStream {
    private final BaseEncoding baseEncoding = BaseEncoding.base64().withSeparator("\n", 76);
    private final XMLStreamWriter xmlStreamWriter;
    private byte[] bytes = new byte[60];
    private int counter;

    public XMLBinaryOutputStream(XMLStreamWriter xmlStreamWriter, String mimeType, String encoding) throws XMLStreamException {
        this.xmlStreamWriter = xmlStreamWriter;
        xmlStreamWriter.writeStartElement("", Ns.QNAME_BINARY_CONTENT.getLocalPart(), "http://peppol.eu/xsd/ticc/envelope/1.0");
        xmlStreamWriter.writeDefaultNamespace("http://peppol.eu/xsd/ticc/envelope/1.0");
        xmlStreamWriter.writeAttribute("mimeType", mimeType);
        if (encoding != null) {
            xmlStreamWriter.writeAttribute("encoding", encoding);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.bytes[this.counter++] = (byte)b;
        if (this.counter == this.bytes.length) {
            try {
                this.xmlStreamWriter.writeCharacters(this.baseEncoding.encode(this.bytes));
                this.counter = 0;
            }
            catch (XMLStreamException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.counter > 0) {
                this.xmlStreamWriter.writeCharacters(this.baseEncoding.encode(Arrays.copyOf(this.bytes, this.counter)));
            }
            this.xmlStreamWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

