/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.sbdh.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public interface XMLStreamUtils {
    public static void copy(Reader reader, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newFactory().createXMLStreamReader(reader);
        XMLStreamUtils.copy(xmlStreamReader, xmlStreamWriter);
        xmlStreamReader.close();
    }

    public static void copy(XMLStreamReader xmlStreamReader, Writer writer) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newFactory().createXMLStreamWriter(writer);
        XMLStreamUtils.copy(xmlStreamReader, xmlStreamWriter);
        xmlStreamWriter.close();
    }

    public static void copy(InputStream inputStream, XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newFactory().createXMLStreamReader(inputStream, "UTF-8");
        XMLStreamUtils.copy(xmlStreamReader, xmlStreamWriter);
        xmlStreamReader.close();
    }

    public static void copy(XMLStreamReader xmlStreamReader, OutputStream outputStream) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newFactory().createXMLStreamWriter(outputStream, "UTF-8");
        XMLStreamUtils.copy(xmlStreamReader, xmlStreamWriter);
        xmlStreamWriter.close();
    }

    public static void copy(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        boolean hasNext;
        do {
            switch (reader.getEventType()) {
                case 7: {
                    writer.writeStartDocument(reader.getEncoding(), reader.getVersion());
                    break;
                }
                case 8: {
                    writer.writeEndDocument();
                    break;
                }
                case 1: {
                    int i;
                    writer.writeStartElement(reader.getPrefix(), reader.getLocalName(), reader.getNamespaceURI());
                    for (i = 0; i < reader.getNamespaceCount(); ++i) {
                        writer.writeNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
                    }
                    for (i = 0; i < reader.getAttributeCount(); ++i) {
                        String prefix = reader.getAttributePrefix(i);
                        if (prefix == null || "".equals(prefix)) {
                            writer.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                            continue;
                        }
                        writer.writeAttribute(prefix, reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                    }
                    break;
                }
                case 2: {
                    writer.writeEndElement();
                    break;
                }
                case 4: {
                    writer.writeCharacters(reader.getText());
                    break;
                }
                case 12: {
                    writer.writeCData(reader.getText());
                }
            }
            hasNext = reader.hasNext();
            if (!hasNext) continue;
            reader.next();
        } while (hasNext);
    }
}

