/*
 * Decompiled with CFR 0.152.
 */
package network.passkeys.client;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.util.AttributeSet;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.browser.customtabs.CustomTabsIntent;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import network.passkeys.client.JavaScriptBridge;
import network.passkeys.client.Passkeys;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\u0018\u0000 -2\u00020\u0001:\u0001-B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010\u0014\u001a\u00020\tJ4\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u001a\u0010\u0019\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u001b\u0012\u0004\u0012\u00020\u00160\u001aJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010 \u001a\u00020\u0016H\u0002J\b\u0010!\u001a\u00020\u0016H\u0002J\b\u0010\"\u001a\u00020\u0016H\u0002J\u0006\u0010#\u001a\u00020\u0016J\b\u0010$\u001a\u00020\u0016H\u0014J\u001a\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\t2\b\u0010'\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010(\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u000e\u0010)\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\tJ\u0010\u0010*\u001a\u00020\u00162\b\u0010\u000b\u001a\u0004\u0018\u00010\tJ\u0010\u0010+\u001a\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\tJ\b\u0010,\u001a\u00020\u0016H\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lnetwork/passkeys/client/Passkeys;", "Landroid/webkit/WebView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "initialUrl", "", "(Landroid/content/Context;Landroid/util/AttributeSet;ILjava/lang/String;)V", "appId", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "deferredResults", "", "Lkotlinx/coroutines/CompletableDeferred;", "Lorg/json/JSONObject;", "url", "callAsyncJavaScript", "script", "callMethod", "", "method", "data", "completion", "Lkotlin/Function1;", "Lkotlin/Result;", "getActivity", "Landroid/app/Activity;", "hasCustomTabsSupport", "", "injectJavaScript", "loadUrlWithBridge", "onCloseSigner", "onDestroy", "onDetachedFromWindow", "onJavaScriptResult", "id", "result", "onOpenSigner", "openInCustomTab", "setAppId", "setUrl", "setupWebView", "Companion", "android_release"})
public final class Passkeys
extends WebView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String initialUrl;
    @NotNull
    private String url;
    @Nullable
    private String appId;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Map<String, CompletableDeferred<JSONObject>> deferredResults;
    @Nullable
    private static Passkeys instance;
    @Nullable
    private static Function0<Unit> customTabCallback;

    @JvmOverloads
    public Passkeys(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, @NotNull String initialUrl) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)initialUrl, (String)"initialUrl");
        super(context, attrs, defStyleAttr);
        this.initialUrl = initialUrl;
        this.url = "";
        this.coroutineScope = CoroutineScopeKt.MainScope();
        this.deferredResults = new LinkedHashMap();
        instance = this;
        this.setupWebView();
        this.url = this.initialUrl;
        this.loadUrlWithBridge();
    }

    public /* synthetic */ Passkeys(Context context, AttributeSet attributeSet, int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            string = "https://relay.passkeys.network";
        }
        this(context, attributeSet, n, string);
    }

    public final void setAppId(@Nullable String appId) {
        this.appId = appId;
        this.loadUrlWithBridge();
    }

    public final void setUrl(@Nullable String url) {
        String string = url;
        if (string == null) {
            string = this.initialUrl;
        }
        this.url = string;
        this.loadUrlWithBridge();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (instance == this) {
            Companion.clearInstance();
        }
    }

    private final Activity getActivity(Context context) {
        if (context instanceof Activity) {
            return (Activity)context;
        }
        try {
            Class<?> reactContextClass = Class.forName("com.facebook.react.bridge.ReactContext");
            if (reactContextClass.isInstance(context)) {
                Object object = reactContextClass.getMethod("getCurrentActivity", new Class[0]).invoke((Object)context, new Object[0]);
                return object instanceof Activity ? (Activity)object : null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private final void setupWebView() {
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setDomStorageEnabled(true);
        this.addJavascriptInterface(new JavaScriptBridge((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ Passkeys this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Passkeys.access$onCloseSigner(this.this$0);
            }
        }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ Passkeys this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Passkeys.access$onOpenSigner(this.this$0, url);
            }
        }), (Function2<? super String, ? super String, Unit>)((Function2)new Function2<String, String, Unit>(this){
            final /* synthetic */ Passkeys this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String id, @Nullable String result) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Passkeys.access$onJavaScriptResult(this.this$0, id, result);
            }
        })), "AndroidBridge");
        this.setWebViewClient(new WebViewClient(){});
    }

    private final void loadUrlWithBridge() {
        String url = this.url + "?appId=" + this.appId;
        this.loadUrl(url);
        this.injectJavaScript();
    }

    private final void injectJavaScript() {
        this.evaluateJavascript("\n            if (!window.nativeBridge) {\n                window.nativeBridge = {};\n            }\n            window.nativeBridge.closeSigner = function() {\n                AndroidBridge.closeSigner();\n            };\n            window.nativeBridge.openSigner = function(url) {\n                if (typeof url !== 'string') throw new Error('url is not a string');\n                AndroidBridge.openSigner(url);\n            };\n            window.nativeBridge.resolveResult = function(id, result) {\n                AndroidBridge.resolveResult(id, result);\n            };\n        ", Passkeys::injectJavaScript$lambda$0);
    }

    private final void onCloseSigner() {
        block0: {
            Function0<Unit> function0 = customTabCallback;
            if (function0 == null) break block0;
            function0.invoke();
        }
    }

    private final void onOpenSigner(String url) {
        this.openInCustomTab(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onJavaScriptResult(String id, String result) {
        try {
            JSONObject jSONObject;
            CharSequence charSequence = result;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || Intrinsics.areEqual((Object)result, (Object)"undefined") || Intrinsics.areEqual((Object)result, (Object)"null")) {
                jSONObject = null;
            } else {
                if (Intrinsics.areEqual((Object)result, (Object)"\"no-method\"")) {
                    throw new IllegalStateException("Unsupported browser");
                }
                jSONObject = new JSONObject(result);
            }
            JSONObject jsonObject = jSONObject;
            CompletableDeferred<JSONObject> completableDeferred = this.deferredResults.get(id);
            if (completableDeferred != null) {
                completableDeferred.complete(jsonObject);
            }
        }
        catch (Exception e) {
            CompletableDeferred<JSONObject> completableDeferred = this.deferredResults.get(id);
            if (completableDeferred != null) {
                completableDeferred.completeExceptionally((Throwable)e);
            }
        }
        finally {
            this.deferredResults.remove(id);
        }
    }

    public final void openInCustomTab(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Uri uri = Uri.parse((String)url);
        CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().build();
        Intrinsics.checkNotNullExpressionValue((Object)customTabsIntent, (String)"build(...)");
        CustomTabsIntent customTabsIntent2 = customTabsIntent;
        Intent intent = customTabsIntent2.intent;
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
        Intent intent2 = intent;
        intent2.setData(uri);
        Context context = this.getContext();
        Intrinsics.checkNotNull((Object)context);
        Activity activity = this.getActivity(context);
        if (activity == null) {
            throw new IllegalStateException("No activity available to open the URL");
        }
        if (this.hasCustomTabsSupport(context)) {
            activity.startActivity(intent2);
        } else {
            Intent fallbackIntent = new Intent("android.intent.action.VIEW", uri);
            activity.startActivity(fallbackIntent);
        }
    }

    private final boolean hasCustomTabsSupport(Context context) {
        PackageManager packageManager = context.getPackageManager();
        Intent activityIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)"https://www.example.com"));
        List list = packageManager.queryIntentActivities(activityIntent, 0);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"queryIntentActivities(...)");
        List resolveInfoList = list;
        for (ResolveInfo resolveInfo : resolveInfoList) {
            Intent serviceIntent = new Intent();
            serviceIntent.setAction("android.support.customtabs.action.CustomTabsService");
            serviceIntent.setPackage(resolveInfo.activityInfo.packageName);
            if (packageManager.resolveService(serviceIntent, 0) == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final CompletableDeferred<JSONObject> callAsyncJavaScript(@NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        CompletableDeferred deferredResult = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String uniqueId = string;
        this.deferredResults.put(uniqueId, (CompletableDeferred<JSONObject>)deferredResult);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, script, uniqueId, null){
            int label;
            final /* synthetic */ Passkeys this$0;
            final /* synthetic */ String $script;
            final /* synthetic */ String $uniqueId;
            {
                this.this$0 = $receiver;
                this.$script = $script;
                this.$uniqueId = $uniqueId;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.evaluateJavascript("\n                (async function() {\n                    try {\n                        const result = await (function() { " + this.$script + " })();\n                        window.nativeBridge.resolveResult('" + this.$uniqueId + "', JSON.stringify(result));\n                    } catch (e) {\n                        window.nativeBridge.resolveResult('" + this.$uniqueId + "', null);\n                    }\n                })();\n                ", callAsyncJavaScript.1::invokeSuspend$lambda$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(String it) {
            }
        }), (int)3, null);
        return deferredResult;
    }

    public final void callMethod(@NotNull String method, @Nullable JSONObject data, @NotNull Function1<? super Result<? extends JSONObject>, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        if (this.appId == null) {
            completion.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalArgumentException("appId cannot be null")))));
            return;
        }
        this.injectJavaScript();
        Object object = data;
        if (object == null || (object = object.toString()) == null) {
            object = "{}";
        }
        Object dataJSON = object;
        String script = "if (!window." + method + ") return 'no-method';\n        else return window." + method + '(' + (String)dataJSON + ");";
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, script, completion, null){
            int label;
            final /* synthetic */ Passkeys this$0;
            final /* synthetic */ String $script;
            final /* synthetic */ Function1<Result<? extends JSONObject>, Unit> $completion;
            {
                this.this$0 = $receiver;
                this.$script = $script;
                this.$completion = $completion;
                super(2, $completion2);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.callAsyncJavaScript(this.$script).await((Continuation)this);
                        ** if (v0 != var3_2) goto lbl11
lbl10:
                        // 1 sources

                        return var3_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            result = (JSONObject)v0;
                            this.$completion.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)result)));
                        }
                        catch (Exception e) {
                            this.$completion.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e))));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void onDestroy() {
        this.loadUrl("about:blank");
        Companion.clearInstance();
        this.clearHistory();
        this.removeAllViews();
        this.destroy();
    }

    @JvmOverloads
    public Passkeys(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, defStyleAttr, null, 8, null);
    }

    @JvmOverloads
    public Passkeys(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, null, 12, null);
    }

    @JvmOverloads
    public Passkeys(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, null, 14, null);
    }

    private static final void injectJavaScript$lambda$0(String it) {
    }

    public static final /* synthetic */ void access$onCloseSigner(Passkeys $this) {
        $this.onCloseSigner();
    }

    public static final /* synthetic */ void access$onOpenSigner(Passkeys $this, String url) {
        $this.onOpenSigner(url);
    }

    public static final /* synthetic */ void access$onJavaScriptResult(Passkeys $this, String id, String result) {
        $this.onJavaScriptResult(id, result);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\u0005J\b\u0010\t\u001a\u0004\u0018\u00010\u0007J\u0014\u0010\n\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnetwork/passkeys/client/Passkeys$Companion;", "", "()V", "customTabCallback", "Lkotlin/Function0;", "", "instance", "Lnetwork/passkeys/client/Passkeys;", "clearInstance", "getInstance", "setOnCloseSignerCallback", "callback", "android_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Passkeys getInstance() {
            return instance;
        }

        public final void clearInstance() {
            instance = null;
        }

        public final void setOnCloseSignerCallback(@NotNull Function0<Unit> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            customTabCallback = callback;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

