/*
 * Decompiled with CFR 0.152.
 */
package network.passkeys.client;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.util.AttributeSet;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import network.passkeys.client.Error;
import network.passkeys.client.JavaScriptBridge;
import network.passkeys.client.Passkeys;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u0000 :2\u00020\u0001:\u0001:B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00142\u0006\u0010\u001f\u001a\u00020\tJ4\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\t2\b\u0010#\u001a\u0004\u0018\u00010\u00152\u001a\u0010$\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150&\u0012\u0004\u0012\u00020!0%J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010)\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010*\u001a\u00020!H\u0002J\b\u0010+\u001a\u00020!H\u0002J\b\u0010,\u001a\u00020!H\u0002J\u0006\u0010-\u001a\u00020!J\b\u0010.\u001a\u00020!H\u0014J\u001a\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020\t2\b\u00101\u001a\u0004\u0018\u00010\tH\u0002J\u001a\u00102\u001a\u00020!2\u0006\u00103\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u00104\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\tH\u0002J\u000e\u00105\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\tJ\u0010\u00106\u001a\u00020!2\b\u0010\u000f\u001a\u0004\u0018\u00010\tJ\u000e\u00107\u001a\u00020!2\u0006\u00103\u001a\u00020\rJ\u0010\u00108\u001a\u00020!2\b\u0010\u001d\u001a\u0004\u0018\u00010\tJ\b\u00109\u001a\u00020!H\u0002R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lnetwork/passkeys/client/Passkeys;", "Landroid/webkit/WebView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "initialUrl", "", "(Landroid/content/Context;Landroid/util/AttributeSet;ILjava/lang/String;)V", "_isLoading", "Landroidx/lifecycle/MutableLiveData;", "", "kotlin.jvm.PlatformType", "appId", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "deferredResults", "", "Lkotlinx/coroutines/CompletableDeferred;", "Lorg/json/JSONObject;", "error", "isLoading", "Landroidx/lifecycle/LiveData;", "()Landroidx/lifecycle/LiveData;", "loadingErrorMessage", "getLoadingErrorMessage", "()Ljava/lang/String;", "url", "callAsyncJavaScript", "script", "callMethod", "", "method", "data", "completion", "Lkotlin/Function1;", "Lkotlin/Result;", "getActivity", "Landroid/app/Activity;", "hasCustomTabsSupport", "injectJavaScript", "loadUrlWithBridge", "onCloseSigner", "onDestroy", "onDetachedFromWindow", "onJavaScriptResult", "id", "result", "onLoadingEnd", "loading", "onOpenSigner", "openInCustomTab", "setAppId", "setLoading", "setUrl", "setupWebView", "Companion", "android_release"})
public final class Passkeys
extends WebView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String initialUrl;
    @NotNull
    private String url;
    @Nullable
    private String appId;
    @NotNull
    private MutableLiveData<Boolean> _isLoading;
    @Nullable
    private String error;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Map<String, CompletableDeferred<JSONObject>> deferredResults;
    @Nullable
    private static Passkeys instance;
    @Nullable
    private static Function0<Unit> customTabCallback;

    @JvmOverloads
    public Passkeys(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, @NotNull String initialUrl) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)initialUrl, (String)"initialUrl");
        super(context, attrs, defStyleAttr);
        this.initialUrl = initialUrl;
        this.url = "";
        this._isLoading = new MutableLiveData((Object)true);
        this.coroutineScope = CoroutineScopeKt.MainScope();
        this.deferredResults = new LinkedHashMap();
        instance = this;
        this.setupWebView();
        this.url = this.initialUrl;
        this.loadUrlWithBridge();
    }

    public /* synthetic */ Passkeys(Context context, AttributeSet attributeSet, int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            string = "https://relay.passkeys.network";
        }
        this(context, attributeSet, n, string);
    }

    public final void setLoading(boolean loading) {
        this._isLoading.setValue((Object)loading);
    }

    @NotNull
    public final LiveData<Boolean> isLoading() {
        return (LiveData)this._isLoading;
    }

    @Nullable
    public final String getLoadingErrorMessage() {
        return this.error;
    }

    public final void setAppId(@Nullable String appId) {
        this.appId = appId;
        this.loadUrlWithBridge();
    }

    public final void setUrl(@Nullable String url) {
        String string = url;
        if (string == null) {
            string = this.initialUrl;
        }
        this.url = string;
        this.loadUrlWithBridge();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (instance == this) {
            Companion.clearInstance();
        }
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
    }

    private final Activity getActivity(Context context) {
        if (context instanceof Activity) {
            return (Activity)context;
        }
        try {
            Class<?> reactContextClass = Class.forName("com.facebook.react.bridge.ReactContext");
            if (reactContextClass.isInstance(context)) {
                Object object = reactContextClass.getMethod("getCurrentActivity", new Class[0]).invoke((Object)context, new Object[0]);
                return object instanceof Activity ? (Activity)object : null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private final void setupWebView() {
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setDomStorageEnabled(true);
        this.addJavascriptInterface(new JavaScriptBridge((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ Passkeys this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Passkeys.access$onCloseSigner(this.this$0);
            }
        }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ Passkeys this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Passkeys.access$onOpenSigner(this.this$0, url);
            }
        }), (Function2<? super String, ? super String, Unit>)((Function2)new Function2<String, String, Unit>(this){
            final /* synthetic */ Passkeys this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String id, @Nullable String result) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Passkeys.access$onJavaScriptResult(this.this$0, id, result);
            }
        }), (Function2<? super Boolean, ? super String, Unit>)((Function2)new Function2<Boolean, String, Unit>(this){
            final /* synthetic */ Passkeys this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(boolean loading, @Nullable String error) {
                Passkeys.access$onLoadingEnd(this.this$0, loading, error);
            }
        })), "AndroidBridge");
        this.setWebViewClient(new WebViewClient(this){
            final /* synthetic */ Passkeys this$0;
            {
                this.this$0 = $receiver;
            }

            public void onPageFinished(@Nullable WebView view, @Nullable String url) {
                super.onPageFinished(view, url);
                Passkeys.access$injectJavaScript(this.this$0);
            }
        });
    }

    private final void loadUrlWithBridge() {
        this.error = null;
        this.setLoading(true);
        String url = this.url + "?appId=" + this.appId;
        this.loadUrl(url);
        this.injectJavaScript();
    }

    private final void injectJavaScript() {
        this.evaluateJavascript("\n            if (!window.nativeBridge) {\n                window.nativeBridge = {};\n            }\n            window.nativeBridge.closeSigner = function() {\n                AndroidBridge.closeSigner();\n            };\n            window.nativeBridge.resolveResult = function(id, result) {\n                AndroidBridge.resolveResult(id, result);\n            };\n            window.nativeBridge.onLoadingEnd = function(loading, error) {\n                AndroidBridge.onLoadingEnd(loading, error ? String(error) : null);\n            };\n            window.nativeBridge.onLoadingEnd(window.loading === false ? false : true, window.loadingError ? window.loadingError : null )\n            window.nativeBridge.openSigner = function(url) {\n                if (typeof url !== 'string') throw new Error('url is not a string');\n                AndroidBridge.openSigner(url);\n            };\n        ", Passkeys::injectJavaScript$lambda$0);
    }

    private final void onCloseSigner() {
        block0: {
            Function0<Unit> function0 = customTabCallback;
            if (function0 == null) break block0;
            function0.invoke();
        }
    }

    private final void onLoadingEnd(boolean loading, String error) {
        this.error = error;
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, loading, null){
            int label;
            final /* synthetic */ Passkeys this$0;
            final /* synthetic */ boolean $loading;
            {
                this.this$0 = $receiver;
                this.$loading = $loading;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.setLoading(this.$loading);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void onOpenSigner(String url) {
        this.openInCustomTab(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onJavaScriptResult(String id, String result) {
        try {
            JSONObject jsonObject;
            JSONObject jSONObject;
            CharSequence charSequence = result;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || Intrinsics.areEqual((Object)result, (Object)"undefined") || Intrinsics.areEqual((Object)result, (Object)"null")) {
                jSONObject = null;
            } else {
                if (Intrinsics.areEqual((Object)result, (Object)"\"no-method\"")) {
                    throw new Error("Method not defined");
                }
                jSONObject = new JSONObject(result);
            }
            JSONObject jSONObject2 = jsonObject = jSONObject;
            boolean bl = jSONObject2 != null ? jSONObject2.optBoolean("isError") : false;
            if (bl) {
                String errorMessage = jsonObject.optString("error", null);
                CharSequence charSequence2 = errorMessage;
                if (!(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2))) {
                    CompletableDeferred<JSONObject> completableDeferred = this.deferredResults.get(id);
                    if (completableDeferred != null) {
                        Intrinsics.checkNotNull((Object)errorMessage);
                        completableDeferred.completeExceptionally((Throwable)new Error(errorMessage));
                    }
                } else {
                    CompletableDeferred<JSONObject> completableDeferred = this.deferredResults.get(id);
                    if (completableDeferred != null) {
                        completableDeferred.completeExceptionally((Throwable)new Error("Unknown JavaScript Error"));
                    }
                }
                return;
            }
            CompletableDeferred<JSONObject> completableDeferred = this.deferredResults.get(id);
            if (completableDeferred != null) {
                completableDeferred.complete((Object)jsonObject);
            }
        }
        catch (Exception e) {
            CompletableDeferred<JSONObject> completableDeferred = this.deferredResults.get(id);
            if (completableDeferred != null) {
                completableDeferred.completeExceptionally((Throwable)e);
            }
        }
        finally {
            this.deferredResults.remove(id);
        }
    }

    public final void openInCustomTab(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Uri uri = Uri.parse((String)url);
        if (!Intrinsics.areEqual((Object)uri.getScheme(), (Object)"http") && !Intrinsics.areEqual((Object)uri.getScheme(), (Object)"https")) {
            System.out.println((Object)"Invalid url.");
            return;
        }
        CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().build();
        Intrinsics.checkNotNullExpressionValue((Object)customTabsIntent, (String)"build(...)");
        CustomTabsIntent customTabsIntent2 = customTabsIntent;
        Intent intent = customTabsIntent2.intent;
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
        Intent intent2 = intent;
        intent2.setData(uri);
        Context context = this.getContext();
        Intrinsics.checkNotNull((Object)context);
        Activity activity = this.getActivity(context);
        if (activity == null) {
            throw new Error("No activity available to open the URL");
        }
        if (this.hasCustomTabsSupport(context)) {
            activity.startActivity(intent2);
        } else {
            Intent fallbackIntent = new Intent("android.intent.action.VIEW", uri);
            activity.startActivity(fallbackIntent);
        }
    }

    private final boolean hasCustomTabsSupport(Context context) {
        PackageManager packageManager = context.getPackageManager();
        Intent activityIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)"https://www.example.com"));
        List list = packageManager.queryIntentActivities(activityIntent, 0);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"queryIntentActivities(...)");
        List resolveInfoList = list;
        for (ResolveInfo resolveInfo : resolveInfoList) {
            Intent serviceIntent = new Intent();
            serviceIntent.setAction("android.support.customtabs.action.CustomTabsService");
            serviceIntent.setPackage(resolveInfo.activityInfo.packageName);
            if (packageManager.resolveService(serviceIntent, 0) == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final CompletableDeferred<JSONObject> callAsyncJavaScript(@NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        CompletableDeferred deferredResult = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String uniqueId = string;
        this.deferredResults.put(uniqueId, (CompletableDeferred<JSONObject>)deferredResult);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, script, uniqueId, null){
            int label;
            final /* synthetic */ Passkeys this$0;
            final /* synthetic */ String $script;
            final /* synthetic */ String $uniqueId;
            {
                this.this$0 = $receiver;
                this.$script = $script;
                this.$uniqueId = $uniqueId;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.this$0.evaluateJavascript("\n                (async function() {\n                    try {\n                        const result = await (function() { " + this.$script + " })();\n                        window.nativeBridge.resolveResult('" + this.$uniqueId + "', JSON.stringify(result));\n                    } catch (error) {\n                        window.nativeBridge.resolveResult('" + this.$uniqueId + "', JSON.stringify({isError: true, error: error && (error.message || String(error))}));\n                    }\n                })();\n                ", callAsyncJavaScript.1::invokeSuspend$lambda$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(String it) {
            }
        }), (int)3, null);
        return deferredResult;
    }

    public final void callMethod(@NotNull String method, @Nullable JSONObject data, @NotNull Function1<? super Result<? extends JSONObject>, Unit> completion) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        if (this.appId == null) {
            completion.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Error("appId cannot be null")))));
            return;
        }
        this.injectJavaScript();
        Object object = data;
        if (object == null || (object = object.toString()) == null) {
            object = "{}";
        }
        Object dataJSON = object;
        String script = "if (!window." + method + ") return 'no-method';\n        else return window." + method + '(' + (String)dataJSON + ");";
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, script, completion, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Passkeys this$0;
            final /* synthetic */ String $script;
            final /* synthetic */ Function1<Result<? extends JSONObject>, Unit> $completion;
            {
                this.this$0 = $receiver;
                this.$script = $script;
                this.$completion = $completion;
                super(2, $completion2);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var4_4 /* !! */  = $this$launch = (CoroutineScope)this.L$0;
                        var5_5 = this.this$0;
                        var6_6 = this.$script;
                        $i$a$-runCatching-Passkeys$callMethod$1$result$1 = false;
                        this.label = 1;
                        v0 = var5_5.callAsyncJavaScript((String)var6_6).await((Continuation)this);
                        ** if (v0 != var9_2) goto lbl16
lbl15:
                        // 1 sources

                        return var9_2;
lbl16:
                        // 1 sources

                        ** GOTO lbl23
                    }
                    case 1: {
                        $i$a$-runCatching-Passkeys$callMethod$1$result$1 = false;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl23:
                            // 2 sources

                            var7_9 = Result.constructor-impl((Object)((JSONObject)v0));
                        }
                        catch (Throwable $i$a$-runCatching-Passkeys$callMethod$1$result$1) {
                            var7_9 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-Passkeys$callMethod$1$result$1));
                        }
                        result = var7_9;
                        var4_4 /* !! */  = result;
                        var5_5 = this.$completion;
                        if (Result.isSuccess-impl((Object)var4_4 /* !! */ )) {
                            it = (JSONObject)var4_4 /* !! */ ;
                            $i$a$-onSuccess-Passkeys$callMethod$1$1 = false;
                            var5_5.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)it)));
                        }
                        var5_5 = this.$completion;
                        v1 = Result.exceptionOrNull-impl((Object)var4_4 /* !! */ );
                        if (v1 != null) {
                            it = var6_6 = v1;
                            $i$a$-onFailure-Passkeys$callMethod$1$2 = false;
                            var5_5.invoke((Object)Result.box-impl((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it))));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void onDestroy() {
        this.loadUrl("about:blank");
        Companion.clearInstance();
        this.stopLoading();
        this.clearHistory();
        this.removeAllViews();
        this.destroy();
    }

    @JvmOverloads
    public Passkeys(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, defStyleAttr, null, 8, null);
    }

    @JvmOverloads
    public Passkeys(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, null, 12, null);
    }

    @JvmOverloads
    public Passkeys(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, null, 14, null);
    }

    private static final void injectJavaScript$lambda$0(String it) {
    }

    public static final /* synthetic */ void access$onCloseSigner(Passkeys $this) {
        $this.onCloseSigner();
    }

    public static final /* synthetic */ void access$onOpenSigner(Passkeys $this, String url) {
        $this.onOpenSigner(url);
    }

    public static final /* synthetic */ void access$onJavaScriptResult(Passkeys $this, String id, String result) {
        $this.onJavaScriptResult(id, result);
    }

    public static final /* synthetic */ void access$onLoadingEnd(Passkeys $this, boolean loading, String error) {
        $this.onLoadingEnd(loading, error);
    }

    public static final /* synthetic */ void access$injectJavaScript(Passkeys $this) {
        $this.injectJavaScript();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\u0005J\b\u0010\t\u001a\u0004\u0018\u00010\u0007J\u0014\u0010\n\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lnetwork/passkeys/client/Passkeys$Companion;", "", "()V", "customTabCallback", "Lkotlin/Function0;", "", "instance", "Lnetwork/passkeys/client/Passkeys;", "clearInstance", "getInstance", "setOnCloseSignerCallback", "callback", "android_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Passkeys getInstance() {
            return instance;
        }

        public final void clearInstance() {
            instance = null;
        }

        public final void setOnCloseSignerCallback(@NotNull Function0<Unit> callback) {
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            customTabCallback = callback;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

