/*
 * Decompiled with CFR 0.152.
 */
package ninja.codingsolutions.solaredgeapiclient;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import ninja.codingsolutions.solaredgeapiclient.interfaces.SolarEdgeApiClient;
import ninja.codingsolutions.solaredgeapiclient.models.ApiResponse;
import ninja.codingsolutions.solaredgeapiclient.models.DetailedEnergyResponse;
import ninja.codingsolutions.solaredgeapiclient.models.EnvironmentalBenefitsResponse;
import ninja.codingsolutions.solaredgeapiclient.models.MeterType;
import ninja.codingsolutions.solaredgeapiclient.models.OverviewResponse;
import ninja.codingsolutions.solaredgeapiclient.models.SiteDetailsResponse;
import ninja.codingsolutions.solaredgeapiclient.models.SupportedVersionsResponse;
import ninja.codingsolutions.solaredgeapiclient.models.TimeUnitType;
import ninja.codingsolutions.solaredgeapiclient.models.VersionResponse;
import ninja.codingsolutions.solaredgeapiclient.models.impl.DetailedEnergyResponseImpl;
import ninja.codingsolutions.solaredgeapiclient.models.impl.EnvironmentalBenefitsResponseImpl;
import ninja.codingsolutions.solaredgeapiclient.models.impl.OverviewResponseImpl;
import ninja.codingsolutions.solaredgeapiclient.models.impl.SiteDetailsResponseImpl;
import ninja.codingsolutions.solaredgeapiclient.models.impl.SupportedVersionsResponseImpl;
import ninja.codingsolutions.solaredgeapiclient.models.impl.VersionResponseImpl;

public class SolarEdgeApiClientImpl
implements SolarEdgeApiClient {
    private final HttpClient client;
    private final String endPoint;
    private final String apiKey;
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String TIME_FORMAT_STRING = "yyyy-MM-dd hh:mm:ss";
    private static final String ENERGY_DETAILS_URL = "%s/site/%s/energyDetails?meters=%s&timeUnit=%s&startTime=%s&endTime=%s&api_key=%s";

    private static <T extends ApiResponse> T getMessageFromBody(String jsonStr, Class<T> cls) throws IOException {
        return (T)((ApiResponse)mapper.readValue(jsonStr, cls));
    }

    private static List<Integer> buildSiteIdListFromSingleValue(Integer siteId) {
        ArrayList<Integer> siteIds = new ArrayList<Integer>();
        siteIds.add(siteId);
        return siteIds;
    }

    private static CompletableFuture<String> getResponseFromApi(String url, HttpClient client) {
        HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create(url)).build();
        return client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApplyAsync(HttpResponse::body);
    }

    private static String encode(String val) {
        return URLEncoder.encode(val, StandardCharsets.UTF_8);
    }

    private CompletableFuture<? extends ApiResponse> getObjectFromResponse(String url, HttpClient client, Class<? extends ApiResponse> cl, List<Integer> siteIds) {
        var ref = new Object(){
            CompletableFuture<? extends ApiResponse> cResp = null;
        };
        ref.cResp = SolarEdgeApiClientImpl.getResponseFromApi(url, client).thenApplyAsync(resp -> {
            try {
                Object apiResp = SolarEdgeApiClientImpl.getMessageFromBody(resp, cl);
                apiResp.setSiteIds(siteIds);
                return apiResp;
            }
            catch (IOException e) {
                ref.cResp.completeExceptionally(e);
                return null;
            }
        });
        return ref.cResp;
    }

    public CompletableFuture<SiteDetailsResponse> getSiteDetails(int siteId) {
        String url = String.format("%s/site/%s/details?api_key=%s", this.endPoint, siteId, this.apiKey);
        return this.getObjectFromResponse(url, this.client, SiteDetailsResponseImpl.class, SolarEdgeApiClientImpl.buildSiteIdListFromSingleValue(siteId));
    }

    public CompletableFuture<OverviewResponse> getOverviewResponse(int siteId) {
        String url = String.format("%s/site/%s/overview?api_key=%s", this.endPoint, siteId, this.apiKey);
        return this.getObjectFromResponse(url, this.client, OverviewResponseImpl.class, SolarEdgeApiClientImpl.buildSiteIdListFromSingleValue(siteId));
    }

    public CompletableFuture<VersionResponse> getVersion() {
        String url = String.format("%s/version/current?api_key=%s", this.endPoint, this.apiKey);
        return this.getObjectFromResponse(url, this.client, VersionResponseImpl.class, null);
    }

    public CompletableFuture<SupportedVersionsResponse> getSupportedVersions() {
        String url = String.format("%s/version/supported?api_key=%s", this.endPoint, this.apiKey);
        return this.getObjectFromResponse(url, this.client, SupportedVersionsResponseImpl.class, null);
    }

    @Override
    public CompletionStage<EnvironmentalBenefitsResponse> getEnvironmentalBenefits(int siteId) {
        String url = String.format("%s/site/%s/envBenefits?systemUnits=Imperial&api_key=%s", this.endPoint, siteId, this.apiKey);
        return this.getObjectFromResponse(url, this.client, EnvironmentalBenefitsResponseImpl.class, SolarEdgeApiClientImpl.buildSiteIdListFromSingleValue(siteId));
    }

    public CompletableFuture<DetailedEnergyResponse> getDetailedEnergyReport(int siteId, List<MeterType> meters, TimeUnitType timeUnitType, ZonedDateTime startTime, ZonedDateTime endTime) {
        String startTimeString = SolarEdgeApiClientImpl.encode(DateTimeFormatter.ofPattern(TIME_FORMAT_STRING).format(startTime));
        String endTimeString = SolarEdgeApiClientImpl.encode(DateTimeFormatter.ofPattern(TIME_FORMAT_STRING).format(endTime));
        String url = String.format(ENERGY_DETAILS_URL, new Object[]{this.endPoint, siteId, meters.stream().map(Enum::toString).collect(Collectors.joining(",")), timeUnitType, startTimeString, endTimeString, this.apiKey});
        return this.getObjectFromResponse(url, this.client, DetailedEnergyResponseImpl.class, SolarEdgeApiClientImpl.buildSiteIdListFromSingleValue(siteId));
    }

    public SolarEdgeApiClientImpl(HttpClient client, String endPoint, String apiKey) {
        this.client = client;
        this.endPoint = endPoint;
        this.apiKey = apiKey;
    }
}

