/*
 * Decompiled with CFR 0.152.
 */
package ninja.codingsolutions.solaredgeapiclient.models.impl;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import ninja.codingsolutions.solaredgeapiclient.models.EnvironmentalBenefits;

@JsonDeserialize(builder=GasEmissionsSavedImplBuilderImpl.class)
public class GasEmissionsSavedImpl
implements EnvironmentalBenefits.GasEmissionsSaved {
    private final EnvironmentalBenefits.EmissionUnitType units;
    private final double co2;
    private final double nox;
    private final double so2;

    protected GasEmissionsSavedImpl(GasEmissionsSavedImplBuilder<?, ?> b) {
        this.units = b.units;
        this.co2 = b.co2;
        this.nox = b.nox;
        this.so2 = b.so2;
    }

    public static GasEmissionsSavedImplBuilder<?, ?> builder() {
        return new GasEmissionsSavedImplBuilderImpl();
    }

    @Override
    public EnvironmentalBenefits.EmissionUnitType getUnits() {
        return this.units;
    }

    @Override
    public double getCo2() {
        return this.co2;
    }

    @Override
    public double getNox() {
        return this.nox;
    }

    @Override
    public double getSo2() {
        return this.so2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GasEmissionsSavedImpl)) {
            return false;
        }
        GasEmissionsSavedImpl other = (GasEmissionsSavedImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getCo2(), other.getCo2()) != 0) {
            return false;
        }
        if (Double.compare(this.getNox(), other.getNox()) != 0) {
            return false;
        }
        if (Double.compare(this.getSo2(), other.getSo2()) != 0) {
            return false;
        }
        EnvironmentalBenefits.EmissionUnitType this$units = this.getUnits();
        EnvironmentalBenefits.EmissionUnitType other$units = other.getUnits();
        return !(this$units == null ? other$units != null : !((Object)((Object)this$units)).equals((Object)other$units));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GasEmissionsSavedImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $co2 = Double.doubleToLongBits(this.getCo2());
        result = result * 59 + (int)($co2 >>> 32 ^ $co2);
        long $nox = Double.doubleToLongBits(this.getNox());
        result = result * 59 + (int)($nox >>> 32 ^ $nox);
        long $so2 = Double.doubleToLongBits(this.getSo2());
        result = result * 59 + (int)($so2 >>> 32 ^ $so2);
        EnvironmentalBenefits.EmissionUnitType $units = this.getUnits();
        result = result * 59 + ($units == null ? 43 : ((Object)((Object)$units)).hashCode());
        return result;
    }

    public String toString() {
        return "GasEmissionsSavedImpl(units=" + this.getUnits() + ", co2=" + this.getCo2() + ", nox=" + this.getNox() + ", so2=" + this.getSo2() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class GasEmissionsSavedImplBuilderImpl
    extends GasEmissionsSavedImplBuilder<GasEmissionsSavedImpl, GasEmissionsSavedImplBuilderImpl> {
        private GasEmissionsSavedImplBuilderImpl() {
        }

        @Override
        protected GasEmissionsSavedImplBuilderImpl self() {
            return this;
        }

        @Override
        public GasEmissionsSavedImpl build() {
            return new GasEmissionsSavedImpl(this);
        }
    }

    public static abstract class GasEmissionsSavedImplBuilder<C extends GasEmissionsSavedImpl, B extends GasEmissionsSavedImplBuilder<C, B>> {
        private EnvironmentalBenefits.EmissionUnitType units;
        private double co2;
        private double nox;
        private double so2;

        protected abstract B self();

        public abstract C build();

        public B units(EnvironmentalBenefits.EmissionUnitType units) {
            this.units = units;
            return this.self();
        }

        public B co2(double co2) {
            this.co2 = co2;
            return this.self();
        }

        public B nox(double nox) {
            this.nox = nox;
            return this.self();
        }

        public B so2(double so2) {
            this.so2 = so2;
            return this.self();
        }

        public String toString() {
            return "GasEmissionsSavedImpl.GasEmissionsSavedImplBuilder(units=" + this.units + ", co2=" + this.co2 + ", nox=" + this.nox + ", so2=" + this.so2 + ")";
        }
    }
}

