/*
 * Decompiled with CFR 0.152.
 */
package ninja.codingsolutions.solaredgeapiclient.models.impl;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import ninja.codingsolutions.solaredgeapiclient.deserializers.CustomDateDeserializer;
import ninja.codingsolutions.solaredgeapiclient.models.TimestampedValue;
import ninja.codingsolutions.solaredgeapiclient.serializers.CustomDateSerializer;

@JsonDeserialize(builder=TimestampedValueImplBuilder.class)
public class TimestampedValueImpl
implements TimestampedValue {
    @JsonDeserialize(using=CustomDateDeserializer.class)
    @JsonSerialize(using=CustomDateSerializer.class)
    private final Date date;
    private final double value;

    TimestampedValueImpl(Date date, double value) {
        this.date = date;
        this.value = value;
    }

    public static TimestampedValueImplBuilder builder() {
        return new TimestampedValueImplBuilder();
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimestampedValueImpl)) {
            return false;
        }
        TimestampedValueImpl other = (TimestampedValueImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getValue(), other.getValue()) != 0) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimestampedValueImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        return result;
    }

    public String toString() {
        return "TimestampedValueImpl(date=" + this.getDate() + ", value=" + this.getValue() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class TimestampedValueImplBuilder {
        private Date date;
        private double value;

        TimestampedValueImplBuilder() {
        }

        @JsonDeserialize(using=CustomDateDeserializer.class)
        public TimestampedValueImplBuilder date(Date date) {
            this.date = date;
            return this;
        }

        public TimestampedValueImplBuilder value(double value) {
            this.value = value;
            return this;
        }

        public TimestampedValueImpl build() {
            return new TimestampedValueImpl(this.date, this.value);
        }

        public String toString() {
            return "TimestampedValueImpl.TimestampedValueImplBuilder(date=" + this.date + ", value=" + this.value + ")";
        }
    }
}

