/*
 * Decompiled with CFR 0.152.
 */
package ninja.codingsolutions.solaredgeapiclient;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import ninja.codingsolutions.solaredgeapiclient.interfaces.SolarEdgeApiClient;
import ninja.codingsolutions.solaredgeapiclient.models.OverviewResponse;
import ninja.codingsolutions.solaredgeapiclient.models.SiteDetailsResponse;

public class SolarEdgeApiClientImpl
implements SolarEdgeApiClient {
    private final HttpClient client;
    private final String endPoint;
    private final String apiKey;
    private static final ObjectMapper mapper = new ObjectMapper();

    private static <T> T getMessageFromBody(String jsonStr, Class<T> cls) throws IOException {
        return (T)mapper.readValue(jsonStr, cls);
    }

    private static CompletableFuture<String> getResponseFromApi(String url, HttpClient client) {
        HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create(url)).build();
        return client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApplyAsync(HttpResponse::body);
    }

    private CompletableFuture<?> getObjectFromResponse(String url, HttpClient client, Class<?> cl) {
        var ref = new Object(){
            CompletableFuture<?> cResp = null;
        };
        ref.cResp = SolarEdgeApiClientImpl.getResponseFromApi(url, client).thenApplyAsync(resp -> {
            try {
                return SolarEdgeApiClientImpl.getMessageFromBody(resp, cl);
            }
            catch (IOException e) {
                ref.cResp.completeExceptionally(e);
                return null;
            }
        });
        return ref.cResp;
    }

    @Override
    public CompletableFuture<SiteDetailsResponse> getSiteDetails(int siteId) {
        String url = String.format("%s/site/%s/details?api_key=%s", this.endPoint, siteId, this.apiKey);
        return this.getObjectFromResponse(url, this.client, SiteDetailsResponse.class);
    }

    @Override
    public CompletableFuture<OverviewResponse> getOverviewResponse(int siteId) {
        String url = String.format("%s/site/%s/overview?api_key=%s", this.endPoint, siteId, this.apiKey);
        return this.getObjectFromResponse(url, this.client, OverviewResponse.class);
    }

    public SolarEdgeApiClientImpl(HttpClient client, String endPoint, String apiKey) {
        this.client = client;
        this.endPoint = endPoint;
        this.apiKey = apiKey;
    }
}

