package ninja.codingsolutions.solaredgeapiclient.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import ninja.codingsolutions.solaredgeapiclient.models.impl.EnvironmentBenefitsImpl;
import ninja.codingsolutions.solaredgeapiclient.models.impl.GasEmissionsSavedImpl;

/**
 * Estimated environmental benefits from site
 */
@JsonDeserialize(as = EnvironmentBenefitsImpl.class)
public interface EnvironmentalBenefits {
    /**
     * Units of gasses
     */
    enum EmissionUnitType {
        /**
         * pounds
         */
        @JsonProperty("lb")
        LB
    }
    @JsonDeserialize(as = GasEmissionsSavedImpl.class)
    interface GasEmissionsSaved {
        /**
         * Get the associated unit type for all of the associated gas emissions
         * @return Unit type for all gas values
         */
        EmissionUnitType getUnits();

        /**
         * get the typical amount of CO2 emissions from fossil fuel power plants that would be
         * emitted to generate the total amount of power that has been generated by this site.
         * @return amount of CO2
         */
        double getCo2();

        /**
         * get the typical amount of SO2 emissions from fossil fuel power plants that would be
         * emitted to generate the total amount of power that has been generated by this site.
         * @return aount of SO2
         */
        double getSo2();

        /**
         * get the typical amount of Nox emissions from fossil fuel power plants that would be
         * emitted to generate the total amount of power that has been generated by this site.
         * @return amount of Nox
         */
        double getNox();
    }

    /**
     * Get the information on the amount of gas emissions that have been prevented by
     * using solar power instead of power from grid that can come from sources that
     * emit greenhouse gases
     * @return Gas Emission Reduction
     */
    GasEmissionsSaved getGasEmissionSaved();

    /**
     * Estimated amount of trees that would need to be planted to have the equivalent
     * reduction of gas emissions
     * @return tree count
     */
    double getTreesPlanted();

    /**
     * Get the equivalent amount of light bulbs powered from total power generated
     * @return number of light bulbs that could have been powered from total power
     */
    double getLightBulbs();
}
