/*
 * Decompiled with CFR 0.152.
 */
package ninja.codingsolutions.solaredgeapiclient;

import java.net.http.HttpClient;
import ninja.codingsolutions.solaredgeapiclient.SolarEdgeApiClientImpl;
import ninja.codingsolutions.solaredgeapiclient.interfaces.SolarEdgeApiClient;

public final class SolarEdgeClientFactory {
    private final String apiUrl;
    private final String apiKey;
    private final HttpClient httpClient;

    public SolarEdgeApiClient buildClient() {
        return new SolarEdgeApiClientImpl(this.httpClient, this.apiUrl, this.apiKey);
    }

    public static SolarEdgeClientFactoryBuilder builder() {
        return new SolarEdgeClientFactoryBuilder();
    }

    public SolarEdgeClientFactory(String apiUrl, String apiKey, HttpClient httpClient) {
        this.apiUrl = apiUrl;
        this.apiKey = apiKey;
        this.httpClient = httpClient;
    }

    public static class SolarEdgeClientFactoryBuilder {
        private String apiUrl;
        private String apiKey;
        private HttpClient httpClient;

        SolarEdgeClientFactoryBuilder() {
        }

        public SolarEdgeClientFactoryBuilder apiUrl(String apiUrl) {
            this.apiUrl = apiUrl;
            return this;
        }

        public SolarEdgeClientFactoryBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public SolarEdgeClientFactoryBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public SolarEdgeClientFactory build() {
            return new SolarEdgeClientFactory(this.apiUrl, this.apiKey, this.httpClient);
        }

        public String toString() {
            return "SolarEdgeClientFactory.SolarEdgeClientFactoryBuilder(apiUrl=" + this.apiUrl + ", apiKey=" + this.apiKey + ", httpClient=" + this.httpClient + ")";
        }
    }
}

