/*
 * Decompiled with CFR 0.152.
 */
package ninja.codingsolutions.solaredgeapiclient.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class CustomDateDeserializer
extends StdDeserializer<Date> {
    private final SimpleDateFormat solarEdgeDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private final SimpleDateFormat solarEdgeDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");

    public CustomDateDeserializer() {
        super(Date.class);
    }

    public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String jsonStr = jp.getText();
        Date returnDate = null;
        String timeZone = "UTC";
        try {
            this.iso8601.setTimeZone(TimeZone.getTimeZone(timeZone));
            returnDate = this.iso8601.parse(jsonStr);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (returnDate == null) {
            try {
                returnDate = this.solarEdgeDateTimeFormat.parse(jsonStr);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (returnDate == null) {
            try {
                this.solarEdgeDateFormat.setTimeZone(TimeZone.getTimeZone(timeZone));
                returnDate = this.solarEdgeDateFormat.parse(jsonStr);
            }
            catch (ParseException e) {
                throw new IOException(e.getMessage());
            }
        }
        return returnDate;
    }
}

