/*
 * Decompiled with CFR 0.152.
 */
package ninja.codingsolutions.solaredgeapiclient.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class CustomDateSerializer
extends StdSerializer<Date> {
    private final SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");

    public CustomDateSerializer() {
        super(Date.class);
    }

    public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        this.iso8601.setTimeZone(TimeZone.getTimeZone("UTC"));
        jgen.writeString(this.iso8601.format(value));
    }
}

