/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.dsmr;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimestampParser {
    private static final String TIME_FORMAT = "([0-9][0-9])([01][0-9])([0-3][0-9])([0-2][0-9])([0-5][0-9])([0-5][0-9])([SsWw]?)";
    private static final Pattern DATE_TIME_PATTERN = Pattern.compile("([0-9][0-9])([01][0-9])([0-3][0-9])([0-2][0-9])([0-5][0-9])([0-5][0-9])([SsWw]?)");

    public ZonedDateTime parse(String dsmrTimestamp) {
        ZoneId zoneId;
        if (dsmrTimestamp == null || dsmrTimestamp.isEmpty()) {
            return null;
        }
        Matcher matcher = DATE_TIME_PATTERN.matcher(dsmrTimestamp);
        if (!matcher.find()) {
            return null;
        }
        Instant baseInstant = Instant.ofEpochSecond(0L);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(baseInstant, ZoneOffset.UTC).withYear(2000 + Integer.parseInt(matcher.group(1))).withMonth(Integer.parseInt(matcher.group(2))).withDayOfMonth(Integer.parseInt(matcher.group(3))).withHour(Integer.parseInt(matcher.group(4))).withMinute(Integer.parseInt(matcher.group(5))).withSecond(Integer.parseInt(matcher.group(6)));
        switch (matcher.group(7)) {
            case "S": 
            case "s": {
                zoneId = ZoneOffset.of("+02:00");
                break;
            }
            case "W": 
            case "w": {
                zoneId = ZoneOffset.of("+01:00");
                break;
            }
            default: {
                zoneId = ZoneId.of("Europe/Amsterdam");
            }
        }
        zonedDateTime = zonedDateTime.withZoneSameLocal(zoneId);
        return zonedDateTime;
    }
}

